/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.rules.basic;

import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiActionMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiParameterMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.CodeModelHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.NamingHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.plugin.Config;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlAbstractParam;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlActionType;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlParamType;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.raml10.RJP10V2RamlQueryParameter;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.raml10.RJP10V2RamlUriParameter;
import com.phoenixnap.oss.ramlplugin.raml2code.rules.Rule;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;

public class MethodParamsRule
implements Rule<CodeModelHelper.JExtMethod, JMethod, ApiActionMetadata> {
    boolean addParameterJavadoc = false;
    boolean allowArrayParameters = true;
    boolean allowHeaders = true;

    public MethodParamsRule() {
        this(false, true, true);
    }

    public MethodParamsRule(boolean addParameterJavadoc, boolean allowArrayParameters, boolean allowHeaders) {
        this.addParameterJavadoc = addParameterJavadoc;
        this.allowArrayParameters = allowArrayParameters;
        this.allowHeaders = allowHeaders;
    }

    @Override
    public JMethod apply(ApiActionMetadata endpointMetadata, CodeModelHelper.JExtMethod generatableType) {
        ArrayList<ApiParameterMetadata> parameterMetadataList = new ArrayList<ApiParameterMetadata>();
        parameterMetadataList.addAll(endpointMetadata.getPathVariables());
        parameterMetadataList.addAll(endpointMetadata.getRequestParameters());
        if (this.allowHeaders) {
            parameterMetadataList.addAll(endpointMetadata.getRequestHeaders());
        }
        parameterMetadataList.forEach(paramMetaData -> this.paramQueryForm((ApiParameterMetadata)paramMetaData, generatableType, endpointMetadata));
        if (endpointMetadata.getRequestBody() != null) {
            this.paramObjects(endpointMetadata, generatableType);
        }
        if (Config.isInjectHttpHeadersParameter().booleanValue()) {
            this.paramHttpHeaders(generatableType);
        }
        if (Config.isInjectHttpRequestParameter().booleanValue()) {
            this.paramHttpRequest(generatableType);
        }
        return generatableType.get();
    }

    protected JVar paramQueryForm(ApiParameterMetadata paramMetaData, CodeModelHelper.JExtMethod generatableType, ApiActionMetadata endpointMetadata) {
        String javaName = paramMetaData.getJavaName();
        if (this.addParameterJavadoc) {
            String paramComment = "";
            if (paramMetaData.getRamlParam() != null && StringUtils.hasText((String)paramMetaData.getRamlParam().getDescription())) {
                paramComment = NamingHelper.cleanForJavadoc(paramMetaData.getRamlParam().getDescription());
            }
            generatableType.get().javadoc().addParam(javaName + " " + paramComment);
        }
        JClass type = null;
        if (paramMetaData.getRamlParam() instanceof RJP10V2RamlUriParameter && paramMetaData.isNullable()) {
            type = generatableType.owner().ref(Optional.class).narrow(paramMetaData.getType());
        }
        if (type == null) {
            type = generatableType.owner().ref(paramMetaData.getType());
        }
        if (!this.allowArrayParameters && paramMetaData.isArray()) {
            type = generatableType.owner().ref(paramMetaData.getType().getComponentType());
        }
        JVar jVar = null;
        RamlAbstractParam ramlParam = paramMetaData.getRamlParam();
        if (ramlParam.getType() == RamlParamType.DATA_TYPE && ramlParam instanceof RJP10V2RamlQueryParameter) {
            boolean isPOJO;
            JClass jc = CodeModelHelper.findFirstClassBySimpleName(paramMetaData.getCodeModel(), ramlParam.getRawType());
            jVar = generatableType.get().param((JType)jc, paramMetaData.getName());
            if (Config.getPojoConfig().isIncludeJsr303Annotations() && !RamlActionType.PATCH.equals((Object)endpointMetadata.getActionType()) && jVar.type() instanceof JDefinedClass && (isPOJO = ((JDefinedClass)jVar.type())._package().name().startsWith(Config.getBasePackage()))) {
                jVar.annotate(Valid.class);
            }
            return jVar;
        }
        jVar = generatableType.get().param((JType)type, javaName);
        if (paramMetaData.getRamlParam().getPattern() != null) {
            jVar.annotate(Pattern.class).param("regexp", paramMetaData.getRamlParam().getPattern());
        }
        if (paramMetaData.getRamlParam().getMinLength() != null || paramMetaData.getRamlParam().getMaxLength() != null) {
            JAnnotationUse jAnnotationUse = jVar.annotate(Size.class);
            if (paramMetaData.getRamlParam().getMinLength() != null) {
                jAnnotationUse.param("min", paramMetaData.getRamlParam().getMinLength().intValue());
            }
            if (paramMetaData.getRamlParam().getMaxLength() != null) {
                jAnnotationUse.param("max", paramMetaData.getRamlParam().getMaxLength().intValue());
            }
        }
        if (paramMetaData.getRamlParam().getMinimum() != null) {
            jVar.annotate(Min.class).param("value", paramMetaData.getRamlParam().getMinimum().longValue());
        }
        if (paramMetaData.getRamlParam().getMaximum() != null) {
            jVar.annotate(Max.class).param("value", paramMetaData.getRamlParam().getMaximum().longValue());
        }
        return jVar;
    }

    protected JVar paramObjects(ApiActionMetadata endpointMetadata, CodeModelHelper.JExtMethod generatableType) {
        String requestBodyName;
        String requestBodyFullName = requestBodyName = endpointMetadata.getRequestBody().getName();
        if (BigDecimal.class.getSimpleName().equals(requestBodyName)) {
            requestBodyFullName = BigDecimal.class.getName();
        } else if (BigInteger.class.getSimpleName().equals(requestBodyName)) {
            requestBodyFullName = BigInteger.class.getName();
        }
        boolean array = endpointMetadata.getRequestBody().isArray();
        ArrayList<JCodeModel> codeModels = new ArrayList<JCodeModel>();
        if (endpointMetadata.getRequestBody().getCodeModel() != null) {
            codeModels.add(endpointMetadata.getRequestBody().getCodeModel());
        }
        if (generatableType.owner() != null) {
            codeModels.add(generatableType.owner());
        }
        JClass requestBodyType = CodeModelHelper.findFirstClassBySimpleName(codeModels.toArray(new JCodeModel[codeModels.size()]), requestBodyFullName);
        if (this.allowArrayParameters && array) {
            JClass arrayType = generatableType.owner().ref(List.class);
            requestBodyType = arrayType.narrow(requestBodyType);
        }
        if (this.addParameterJavadoc) {
            generatableType.get().javadoc().addParam(NamingHelper.getParameterName(requestBodyName) + " The Request Body Payload");
        }
        JVar param = generatableType.get().param((JType)requestBodyType, NamingHelper.getParameterName(requestBodyName));
        if (Config.getPojoConfig().isIncludeJsr303Annotations() && !RamlActionType.PATCH.equals((Object)endpointMetadata.getActionType())) {
            param.annotate(Valid.class);
        }
        return param;
    }

    protected JVar paramHttpHeaders(CodeModelHelper.JExtMethod generatableType) {
        JVar paramHttpHeaders = generatableType.get().param(HttpHeaders.class, "httpHeaders");
        if (this.addParameterJavadoc) {
            generatableType.get().javadoc().addParam("httpHeaders The HTTP headers for the request");
        }
        return paramHttpHeaders;
    }

    protected JVar paramHttpRequest(CodeModelHelper.JExtMethod generatableType) {
        JVar paramHttpRequest = generatableType.get().param(HttpServletRequest.class, "httpRequest");
        if (this.addParameterJavadoc) {
            generatableType.get().javadoc().addParam("httpRequest The HTTP request");
        }
        return paramHttpRequest;
    }
}

