/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.rules.spring;

import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiResourceMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.rules.Rule;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JDefinedClass;
import org.springframework.cloud.netflix.feign.FeignClient;

public class SpringFeignClientClassAnnotationRule
implements Rule<JDefinedClass, JAnnotationUse, ApiResourceMetadata> {
    @Override
    public JAnnotationUse apply(ApiResourceMetadata controllerMetadata, JDefinedClass generatableType) {
        JAnnotationUse feignClient = generatableType.annotate(FeignClient.class);
        feignClient.param("path", controllerMetadata.getControllerUrl());
        feignClient.param("name", this.getClientName(controllerMetadata));
        return feignClient;
    }

    private String getClientName(ApiResourceMetadata controllerMetadata) {
        String name = controllerMetadata.getResourceName();
        if (name == null || name.length() == 0) {
            return "Client";
        }
        return name.substring(0, 1).toLowerCase() + name.substring(1) + "Client";
    }
}

