/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.rules.spring;

import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiActionMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiParameterMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.CodeModelHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.RamlTypeHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlHeader;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlParamType;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlUriParameter;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.raml10.RJP10V2RamlQueryParameter;
import com.phoenixnap.oss.ramlplugin.raml2code.rules.basic.MethodParamsRule;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JVar;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

public class SpringMethodParamsRule
extends MethodParamsRule {
    public SpringMethodParamsRule() {
    }

    public SpringMethodParamsRule(boolean addParameterJavadoc, boolean allowArrayParameters, boolean allowHeaders) {
        super(addParameterJavadoc, allowArrayParameters, allowHeaders);
    }

    @Override
    protected JVar paramQueryForm(ApiParameterMetadata paramMetaData, CodeModelHelper.JExtMethod generatableType, ApiActionMetadata endpointMetadata) {
        RJP10V2RamlQueryParameter queryParameter;
        JVar jVar = super.paramQueryForm(paramMetaData, generatableType, endpointMetadata);
        if (paramMetaData.getRamlParam() instanceof RamlUriParameter) {
            JAnnotationUse jAnnotationUse = jVar.annotate(PathVariable.class);
            if (!paramMetaData.getName().equals(jVar.name())) {
                jAnnotationUse.param("name", paramMetaData.getName());
            }
            if (!paramMetaData.getRamlParam().isRequired()) {
                jAnnotationUse.param("required", false);
            }
            return jVar;
        }
        if (paramMetaData.getRamlParam() instanceof RamlHeader) {
            JAnnotationUse jAnnotationUse = jVar.annotate(RequestHeader.class);
            if (!paramMetaData.getName().equals(jVar.name())) {
                jAnnotationUse.param("name", paramMetaData.getName());
            }
            if (!paramMetaData.getRamlParam().isRequired()) {
                jAnnotationUse.param("required", false);
            }
            if (StringUtils.hasText((String)paramMetaData.getRamlParam().getDefaultValue())) {
                jAnnotationUse.param("defaultValue", paramMetaData.getRamlParam().getDefaultValue());
                jAnnotationUse.param("required", false);
            }
            return jVar;
        }
        if (paramMetaData.getRamlParam() == null) {
            return jVar;
        }
        JAnnotationUse jAnnotationUse = jVar.annotate(RequestParam.class);
        if (!paramMetaData.getName().equals(jVar.name())) {
            jAnnotationUse.param("name", paramMetaData.getName());
        }
        if (!paramMetaData.getRamlParam().isRequired()) {
            jAnnotationUse.param("required", false);
        }
        if (StringUtils.hasText((String)paramMetaData.getRamlParam().getDefaultValue())) {
            jAnnotationUse.param("defaultValue", paramMetaData.getRamlParam().getDefaultValue());
            jAnnotationUse.param("required", false);
        }
        if (paramMetaData.getRamlParam().getType() == RamlParamType.DATE && paramMetaData.getRamlParam() instanceof RJP10V2RamlQueryParameter && StringUtils.hasText((String)(queryParameter = (RJP10V2RamlQueryParameter)paramMetaData.getRamlParam()).getRawType())) {
            jAnnotationUse = jVar.annotate(DateTimeFormat.class);
            RamlTypeHelper.annotateDateWithPattern(jAnnotationUse, queryParameter.getRawType(), queryParameter.getFormat());
        }
        return jVar;
    }

    @Override
    protected JVar paramObjects(ApiActionMetadata endpointMetadata, CodeModelHelper.JExtMethod generatableType) {
        JVar param = super.paramObjects(endpointMetadata, generatableType);
        param.annotate(RequestBody.class);
        return param;
    }

    @Override
    protected JVar paramHttpHeaders(CodeModelHelper.JExtMethod generatableType) {
        JVar paramHttpHeaders = super.paramHttpHeaders(generatableType);
        paramHttpHeaders.annotate(RequestHeader.class);
        return paramHttpHeaders;
    }
}

