/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.rules.spring;

import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiActionMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiParameterMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.rules.Rule;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class SpringRequestMappingMethodAnnotationRule
implements Rule<JMethod, JAnnotationUse, ApiActionMetadata> {
    protected static final Logger logger = LoggerFactory.getLogger(SpringRequestMappingMethodAnnotationRule.class);

    @Override
    public JAnnotationUse apply(ApiActionMetadata endpointMetadata, JMethod generatableType) {
        JAnnotationUse requestMappingAnnotation = generatableType.annotate(RequestMapping.class);
        String url = endpointMetadata.getUrl();
        JAnnotationArrayMember jAnnotationArrayMember = requestMappingAnnotation.paramArray("value");
        boolean paramSet = false;
        Iterator<ApiParameterMetadata> iterator = endpointMetadata.getPathVariables().iterator();
        ArrayList<ApiParameterMetadata> optionalUriParameters = new ArrayList<ApiParameterMetadata>();
        while (iterator.hasNext()) {
            ApiParameterMetadata apiParameterMetadata = iterator.next();
            if (!apiParameterMetadata.isNullable() || !this.doesURLContainsParamName(url, apiParameterMetadata)) continue;
            optionalUriParameters.add(apiParameterMetadata);
        }
        if (!optionalUriParameters.isEmpty()) {
            if (optionalUriParameters.size() > 1) {
                logger.warn("{} optional path variables (uriParameters) found which can lead to unpredictable results. Please consider refactoring your API!", (Object)optionalUriParameters.size());
            }
            jAnnotationArrayMember.param(url);
            HashSet<String> urls = new HashSet<String>();
            for (int i = 1; i <= optionalUriParameters.size(); ++i) {
                List<List<ApiParameterMetadata>> combination = SpringRequestMappingMethodAnnotationRule.combination(optionalUriParameters, i);
                for (List<ApiParameterMetadata> list : combination) {
                    String urlWithoutParam = url;
                    for (ApiParameterMetadata apiParameterMetadata : list) {
                        urlWithoutParam = urlWithoutParam.replace(this.getApiParameterMetadataURLPart(apiParameterMetadata), "");
                        urlWithoutParam = urlWithoutParam.replaceAll("//", "/");
                    }
                    urls.add(urlWithoutParam);
                }
            }
            for (String urlWithoutParam : urls) {
                jAnnotationArrayMember.param(urlWithoutParam);
            }
            paramSet = true;
        }
        if (!paramSet) {
            requestMappingAnnotation.param("value", url);
        }
        requestMappingAnnotation.param("method", (Enum)RequestMethod.valueOf((String)endpointMetadata.getActionType().name()));
        return requestMappingAnnotation;
    }

    protected boolean doesURLContainsParamName(String url, ApiParameterMetadata apiParameterMetadata) {
        return url.contains(this.getApiParameterMetadataURLPart(apiParameterMetadata));
    }

    protected String getApiParameterMetadataURLPart(ApiParameterMetadata apiParameterMetadata) {
        return "{" + apiParameterMetadata.getName() + "}";
    }

    public static List<List<ApiParameterMetadata>> combination(List<ApiParameterMetadata> values, int size) {
        if (0 == size) {
            return Collections.singletonList(Collections.emptyList());
        }
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<List<ApiParameterMetadata>> combination = new LinkedList<List<ApiParameterMetadata>>();
        ApiParameterMetadata actual = values.iterator().next();
        LinkedList<ApiParameterMetadata> subSet = new LinkedList<ApiParameterMetadata>(values);
        subSet.remove(actual);
        List<List<ApiParameterMetadata>> subSetCombination = SpringRequestMappingMethodAnnotationRule.combination(subSet, size - 1);
        for (List<ApiParameterMetadata> set : subSetCombination) {
            LinkedList<ApiParameterMetadata> newSet = new LinkedList<ApiParameterMetadata>(set);
            newSet.add(0, actual);
            combination.add(newSet);
        }
        combination.addAll(SpringRequestMappingMethodAnnotationRule.combination(subSet, size));
        return combination;
    }
}

