/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.rules.spring;

import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiActionMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.rules.Rule;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JMethod;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class SpringShortcutMappingMethodAnnotationRule
implements Rule<JMethod, JAnnotationUse, ApiActionMetadata> {
    @Override
    public JAnnotationUse apply(ApiActionMetadata endpointMetadata, JMethod generatableType) {
        JAnnotationUse requestMappingAnnotation;
        switch (RequestMethod.valueOf((String)endpointMetadata.getActionType().name())) {
            case GET: {
                requestMappingAnnotation = generatableType.annotate(GetMapping.class);
                break;
            }
            case POST: {
                requestMappingAnnotation = generatableType.annotate(PostMapping.class);
                break;
            }
            case PUT: {
                requestMappingAnnotation = generatableType.annotate(PutMapping.class);
                break;
            }
            case PATCH: {
                requestMappingAnnotation = generatableType.annotate(PatchMapping.class);
                break;
            }
            case DELETE: {
                requestMappingAnnotation = generatableType.annotate(DeleteMapping.class);
                break;
            }
            default: {
                requestMappingAnnotation = generatableType.annotate(RequestMapping.class);
                requestMappingAnnotation.param("method", (Enum)RequestMethod.valueOf((String)endpointMetadata.getActionType().name()));
            }
        }
        if (StringUtils.isNotBlank((String)endpointMetadata.getUrl())) {
            requestMappingAnnotation.param("value", endpointMetadata.getUrl());
        }
        return requestMappingAnnotation;
    }
}

