/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Random;

public final class Lambdas {
    private Lambdas() {
        throw new UnsupportedOperationException();
    }

    public static <T, U> T makeLambda(Class<T> lambdaType, Generator<U> returnValueGenerator, GenerationStatus status) {
        if (Reflection.singleAbstractMethodOf(lambdaType) == null) {
            throw new IllegalArgumentException(lambdaType + " is not a functional interface type");
        }
        return lambdaType.cast(Proxy.newProxyInstance(lambdaType.getClassLoader(), new Class[]{lambdaType}, new LambdaInvocationHandler<T, U>(lambdaType, returnValueGenerator, status, new Random())));
    }

    private static class LambdaInvocationHandler<T, U>
    implements InvocationHandler {
        private final Random random;
        private final Generator<U> returnValueGenerator;
        private final GenerationStatus status;
        private final Class<T> lambdaType;

        LambdaInvocationHandler(Class<T> lambdaType, Generator<U> returnValueGenerator, GenerationStatus status, Random random) {
            this.lambdaType = lambdaType;
            this.returnValueGenerator = returnValueGenerator;
            this.status = status;
            this.random = random;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            if (Object.class.equals(method.getDeclaringClass())) {
                return this.handleObjectMethod(proxy, method, args);
            }
            this.random.setSeed(Arrays.hashCode(args));
            return this.returnValueGenerator.generate(new SourceOfRandomness(this.random), this.status);
        }

        private Object handleObjectMethod(Object proxy, Method method, Object[] args) {
            if ("equals".equals(method.getName())) {
                return proxy == args[0];
            }
            if ("hashCode".equals(method.getName())) {
                return System.identityHashCode(proxy);
            }
            return this.handleToString();
        }

        private String handleToString() {
            return "a randomly generated instance of " + this.lambdaType;
        }
    }
}

