/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.internal.ParameterContext;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.internal.generator.GeneratorRepository;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class Fields<T>
extends Generator<T> {
    private final List<Field> fields;
    private final List<Generator<?>> fieldGenerators = new ArrayList();

    public Fields(Class<T> type) {
        super(type);
        this.fields = Reflection.allDeclaredFieldsOf(type);
        Reflection.instantiate(type);
    }

    @Override
    public T generate(SourceOfRandomness random, GenerationStatus status) {
        Class type = this.types().get(0);
        Object generated = Reflection.instantiate(type);
        for (Field each : Reflection.allDeclaredFieldsOf(type)) {
            ParameterContext parameter = new ParameterContext(each.getName(), each.getAnnotatedType()).annotate(each);
            Reflection.setField(each, generated, this.generatorFor(parameter).generate(random, status), true);
        }
        return type.cast(generated);
    }

    @Override
    public boolean canRegisterAsType(Class<?> type) {
        return false;
    }

    @Override
    public void provideRepository(GeneratorRepository provided) {
        super.provideRepository(provided);
        this.fieldGenerators.clear();
        for (Field each : this.fields) {
            this.fieldGenerators.add(this.generatorFor(new ParameterContext(each.getName(), each.getAnnotatedType()).annotate(each)));
        }
    }

    @Override
    public void configure(AnnotatedType annotatedType) {
        super.configure(annotatedType);
        for (int i = 0; i < this.fields.size(); ++i) {
            this.fieldGenerators.get(i).configure(this.fields.get(i).getAnnotatedType());
        }
    }
}

