/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.GeneratorConfiguration;
import com.pholser.junit.quickcheck.internal.ParameterContext;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.internal.ReflectionException;
import com.pholser.junit.quickcheck.internal.generator.GeneratorRepository;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.javaruntype.type.ExtendsTypeParameter;
import org.javaruntype.type.StandardTypeParameter;
import org.javaruntype.type.TypeParameter;
import org.javaruntype.type.Types;
import org.javaruntype.type.WildcardTypeParameter;

public abstract class Generator<T> {
    private final List<Class<T>> types = new ArrayList<Class<T>>();
    private GeneratorRepository repo;

    protected Generator(Class<T> type) {
        this(Arrays.asList(type));
    }

    protected Generator(List<Class<T>> types) {
        this.types.addAll(types);
    }

    public List<Class<T>> types() {
        return Collections.unmodifiableList(this.types);
    }

    public boolean canRegisterAsType(Class<?> type) {
        return true;
    }

    public abstract T generate(SourceOfRandomness var1, GenerationStatus var2);

    public boolean hasComponents() {
        return false;
    }

    public int numberOfNeededComponents() {
        return 0;
    }

    public void addComponentGenerators(List<Generator<?>> newComponents) {
    }

    public boolean canGenerateForParametersOfTypes(List<TypeParameter<?>> typeParameters) {
        return true;
    }

    public static boolean compatibleWithTypeParameter(TypeParameter<?> parameter, Class<?> clazz) {
        if (parameter instanceof WildcardTypeParameter) {
            return true;
        }
        if (parameter instanceof StandardTypeParameter) {
            StandardTypeParameter standard = (StandardTypeParameter)parameter;
            return standard.getType().isAssignableFrom(Types.forJavaLangReflectType(clazz));
        }
        if (parameter instanceof ExtendsTypeParameter) {
            ExtendsTypeParameter extend = (ExtendsTypeParameter)parameter;
            return Types.forJavaLangReflectType(clazz).isAssignableFrom(extend.getType());
        }
        return parameter.getType().isAssignableFrom(Types.forJavaLangReflectType(clazz));
    }

    public void configure(AnnotatedType annotatedType) {
        List configs = Reflection.allAnnotations(annotatedType).stream().filter(a -> a.annotationType().isAnnotationPresent(GeneratorConfiguration.class)).collect(Collectors.toList());
        HashMap<Class<? extends Annotation>, Annotation> byType = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation each : configs) {
            byType.put(each.annotationType(), each);
        }
        this.configure(byType);
    }

    private void configure(Map<Class<? extends Annotation>, Annotation> byType) {
        for (Map.Entry<Class<? extends Annotation>, Annotation> each : byType.entrySet()) {
            this.configure(each.getKey(), each.getValue());
        }
    }

    private void configure(Class<? extends Annotation> annotationType, Annotation configuration) {
        Method configurer;
        try {
            configurer = Reflection.findMethod(this.getClass(), "configure", annotationType);
        }
        catch (ReflectionException ex) {
            return;
        }
        Reflection.invoke(configurer, this, configuration);
    }

    protected final List<AnnotatedType> annotatedComponentTypes(AnnotatedType annotatedType) {
        if (annotatedType instanceof AnnotatedParameterizedType) {
            return Arrays.asList(((AnnotatedParameterizedType)annotatedType).getAnnotatedActualTypeArguments());
        }
        if (annotatedType instanceof AnnotatedArrayType) {
            return Arrays.asList(((AnnotatedArrayType)annotatedType).getAnnotatedGenericComponentType());
        }
        if (annotatedType instanceof AnnotatedWildcardType) {
            AnnotatedWildcardType wildcard = (AnnotatedWildcardType)annotatedType;
            if (wildcard.getAnnotatedLowerBounds().length > 0) {
                return Arrays.asList(wildcard.getAnnotatedLowerBounds());
            }
            return Arrays.asList(wildcard.getAnnotatedUpperBounds());
        }
        return Collections.emptyList();
    }

    public void provideRepository(GeneratorRepository provided) {
        this.repo = provided;
    }

    Generator<?> generatorFor(ParameterContext parameter) {
        return this.repo.produceGenerator(parameter);
    }
}

