/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal;

import com.pholser.junit.quickcheck.ForAll;
import com.pholser.junit.quickcheck.From;
import com.pholser.junit.quickcheck.SuchThat;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.internal.SampleSizer;
import com.pholser.junit.quickcheck.internal.Weighted;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.javaruntype.type.Type;
import org.javaruntype.type.Types;

public class ParameterContext {
    private static final String EXPLICIT_GENERATOR_TYPE_MISMATCH_MESSAGE = "The generator %s named in @%s on parameter %s does not produce a type-compatible object";
    private final String parameterName;
    private final AnnotatedType parameterType;
    private final List<Weighted<Generator<?>>> explicits = new ArrayList();
    private int configuredSampleSize;
    private SampleSizer sampleSizer;
    private int discardRatio;
    private String constraint;

    public ParameterContext(String parameterName, AnnotatedType parameterType) {
        this.parameterName = parameterName;
        this.parameterType = parameterType;
    }

    public ParameterContext annotate(AnnotatedElement element) {
        this.addQuantifier(element.getAnnotation(ForAll.class));
        this.addConstraint(element.getAnnotation(SuchThat.class));
        this.addGenerators(Reflection.allAnnotationsByType(element, From.class));
        return this;
    }

    public ParameterContext addQuantifier(ForAll quantifier) {
        if (quantifier != null) {
            this.configuredSampleSize = quantifier.sampleSize();
            this.discardRatio = quantifier.discardRatio();
        }
        return this;
    }

    public ParameterContext addConstraint(SuchThat expression) {
        if (expression != null) {
            this.constraint = expression.value();
        }
        return this;
    }

    private ParameterContext addGenerators(List<From> generators) {
        for (From each : generators) {
            Generator<?> generator = this.makeGenerator(each.value());
            this.ensureCorrectType(generator);
            this.explicits.add(new Weighted(generator, each.frequency()));
        }
        return this;
    }

    private Generator<?> makeGenerator(Class<? extends Generator> generatorType) {
        Constructor<? extends Generator> ctor = Reflection.findConstructor(generatorType, Class.class);
        if (ctor != null) {
            return Reflection.instantiate(ctor, this.rawParameterType());
        }
        return Reflection.instantiate(generatorType);
    }

    private Class<?> rawParameterType() {
        if (this.type() instanceof ParameterizedType) {
            return (Class)((ParameterizedType)this.type()).getRawType();
        }
        return (Class)this.type();
    }

    private void ensureCorrectType(Generator<?> generator) {
        Type parameterTypeToken = Types.forJavaLangReflectType((java.lang.reflect.Type)this.type());
        for (Class<?> each : generator.types()) {
            if (Reflection.maybeWrap(parameterTypeToken.getRawClass()).isAssignableFrom(Reflection.maybeWrap(each))) continue;
            throw new IllegalArgumentException(String.format(EXPLICIT_GENERATOR_TYPE_MISMATCH_MESSAGE, each, From.class.getName(), this.parameterName));
        }
    }

    public AnnotatedType annotatedType() {
        return this.parameterType;
    }

    public java.lang.reflect.Type type() {
        return this.parameterType.getType();
    }

    public int sampleSize() {
        if (this.sampleSizer == null) {
            this.sampleSizer = new SampleSizer(this.configuredSampleSize, this);
        }
        return this.sampleSizer.sampleSize();
    }

    public int discardRatio() {
        return this.discardRatio;
    }

    public String constraint() {
        return this.constraint;
    }

    public List<Weighted<Generator<?>>> explicitGenerators() {
        return Collections.unmodifiableList(this.explicits);
    }

    public boolean annotatedWith(Class<? extends Annotation> annotationType) {
        return this.parameterType.getAnnotation(annotationType) != null;
    }
}

