/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal.generator;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.internal.Items;
import com.pholser.junit.quickcheck.internal.Weighted;
import com.pholser.junit.quickcheck.internal.generator.GeneratorRepository;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.List;

public class CompositeGenerator
extends Generator<Object> {
    private final List<Weighted<Generator<?>>> components;

    public CompositeGenerator(List<Weighted<Generator<?>>> components) {
        super(Object.class);
        this.components = new ArrayList(components);
    }

    @Override
    public Object generate(SourceOfRandomness random, GenerationStatus status) {
        Generator choice = (Generator)Items.chooseWeighted(this.components, random);
        return choice.generate(random, status);
    }

    public Generator<?> componentGenerator(int index) {
        return (Generator)this.components.get((int)index).item;
    }

    public int numberOfComponentGenerators() {
        return this.components.size();
    }

    @Override
    public void provideRepository(GeneratorRepository provided) {
        super.provideRepository(provided);
        for (Weighted<Generator<?>> each : this.components) {
            ((Generator)each.item).provideRepository(provided);
        }
    }

    @Override
    public void configure(AnnotatedType annotatedType) {
        for (Weighted<Generator<?>> each : this.components) {
            ((Generator)each.item).configure(annotatedType);
        }
    }
}

