/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal.generator;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.internal.ParameterContext;
import com.pholser.junit.quickcheck.internal.constraint.ConstraintEvaluator;
import com.pholser.junit.quickcheck.internal.generator.GeneratorRepository;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;

public class GenerationContext
implements GenerationStatus {
    private final ParameterContext parameter;
    private final GeneratorRepository repository;
    private final ConstraintEvaluator evaluator;
    private Generator<?> generator;
    private int successfulEvaluations;
    private int discards;

    public GenerationContext(ParameterContext parameter, GeneratorRepository repository) {
        this.parameter = parameter;
        this.repository = repository;
        this.evaluator = new ConstraintEvaluator(parameter.constraint());
    }

    public Object generate(SourceOfRandomness random) {
        return this.generateUsing(this.decideGenerator(), random);
    }

    private Object generateUsing(Generator<?> generator, SourceOfRandomness random) {
        Object nextValue;
        while (!this.evaluate(nextValue = generator.generate(random, this)) && this.shouldContinue()) {
        }
        return nextValue;
    }

    private Generator<?> decideGenerator() {
        if (this.generator == null) {
            this.generator = this.repository.produceGenerator(this.parameter);
        }
        return this.generator;
    }

    private boolean evaluate(Object value) {
        this.evaluator.bind(value);
        boolean result = this.evaluator.evaluate();
        if (result) {
            ++this.successfulEvaluations;
        } else {
            ++this.discards;
        }
        if (this.tooManyDiscards()) {
            throw new DiscardRatioExceededException(this.parameter, this.discards, this.successfulEvaluations);
        }
        return result;
    }

    public boolean shouldContinue() {
        return this.needMoreAttempts() && !this.tooManyDiscards();
    }

    private boolean needMoreAttempts() {
        return this.successfulEvaluations < this.parameter.sampleSize();
    }

    private boolean tooManyDiscards() {
        if (this.parameter.discardRatio() < 0) {
            return true;
        }
        if (this.parameter.discardRatio() == 0) {
            return this.discards > this.parameter.sampleSize();
        }
        return this.successfulEvaluations == 0 ? this.discards > this.parameter.discardRatio() : this.discards / this.successfulEvaluations >= this.parameter.discardRatio();
    }

    @Override
    public int size() {
        return this.successfulEvaluations;
    }

    @Override
    public int attempts() {
        return this.successfulEvaluations + this.discards;
    }

    public static class DiscardRatioExceededException
    extends RuntimeException {
        static final String MESSAGE_TEMPLATE = "For parameter with discard ratio [%d], %d unsuccessful values and %d successes for a discard ratio of [%f]. Stopping.";
        private static final long serialVersionUID = Long.MIN_VALUE;

        DiscardRatioExceededException(ParameterContext parameter, int discards, int successfulEvaluations) {
            super(String.format(MESSAGE_TEMPLATE, parameter.discardRatio(), discards, successfulEvaluations, (double)discards / (double)successfulEvaluations));
        }
    }
}

