/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal.generator;

import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.internal.Items;
import com.pholser.junit.quickcheck.internal.ParameterContext;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.internal.Weighted;
import com.pholser.junit.quickcheck.internal.Zilch;
import com.pholser.junit.quickcheck.internal.generator.ArrayGenerator;
import com.pholser.junit.quickcheck.internal.generator.CompositeGenerator;
import com.pholser.junit.quickcheck.internal.generator.EnumGenerator;
import com.pholser.junit.quickcheck.internal.generator.LambdaGenerator;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.javaruntype.type.ExtendsTypeParameter;
import org.javaruntype.type.StandardTypeParameter;
import org.javaruntype.type.TypeParameter;
import org.javaruntype.type.Types;
import org.javaruntype.type.WildcardTypeParameter;

public class GeneratorRepository {
    private final SourceOfRandomness random;
    private final Map<Class<?>, Set<Generator<?>>> generators = new HashMap();

    public GeneratorRepository(SourceOfRandomness random) {
        this.random = random;
    }

    public GeneratorRepository register(Generator<?> source) {
        this.registerTypes(source);
        return this;
    }

    public GeneratorRepository register(Iterable<Generator<?>> source) {
        for (Generator<?> each : source) {
            this.registerTypes(each);
        }
        return this;
    }

    private void registerTypes(Generator<?> generator) {
        for (Class<?> each : generator.types()) {
            this.registerHierarchy(each, generator);
        }
    }

    private void registerHierarchy(Class<?> type, Generator<?> generator) {
        this.maybeRegisterGeneratorForType(type, generator);
        if (type.getSuperclass() != null) {
            this.registerHierarchy(type.getSuperclass(), generator);
        } else if (type.isInterface()) {
            this.registerHierarchy(Object.class, generator);
        }
        for (Class<?> each : type.getInterfaces()) {
            this.registerHierarchy(each, generator);
        }
    }

    private void maybeRegisterGeneratorForType(Class<?> type, Generator<?> generator) {
        if (generator.canRegisterAsType(type)) {
            this.registerGeneratorForType(type, generator);
        }
    }

    private void registerGeneratorForType(Class<?> type, Generator<?> generator) {
        Set<Generator<?>> forType = this.generators.get(type);
        if (forType == null) {
            forType = new LinkedHashSet();
            this.generators.put(type, forType);
        }
        forType.add(generator);
    }

    public Generator<?> produceGenerator(ParameterContext parameter) {
        Generator<?> generator = this.generatorFor(parameter);
        generator.provideRepository(this);
        generator.configure(parameter.annotatedType());
        return generator;
    }

    public Generator<?> generatorFor(Type type) {
        return this.generatorFor(GeneratorRepository.token(type), true);
    }

    private Generator<?> generatorFor(ParameterContext parameter) {
        if (!parameter.explicitGenerators().isEmpty()) {
            return this.composeWeighted(GeneratorRepository.token(parameter.type()), parameter.explicitGenerators());
        }
        return this.generatorFor(GeneratorRepository.token(parameter.type()), true);
    }

    private Generator<?> generatorFor(org.javaruntype.type.Type<?> token, boolean allowMixedTypes) {
        if (token.isArray()) {
            return this.generatorForArrayType(token);
        }
        if (token.getRawClass().isEnum()) {
            return new EnumGenerator((Class<?>)token.getRawClass());
        }
        return this.compose(token, this.matchingGenerators(token, allowMixedTypes));
    }

    private Generator<?> generatorForArrayType(org.javaruntype.type.Type<?> token) {
        org.javaruntype.type.Type component = Types.arrayComponentOf(token);
        return new ArrayGenerator(component.getRawClass(), this.generatorFor(component, true));
    }

    private List<Generator<?>> matchingGenerators(org.javaruntype.type.Type<?> token, boolean allowMixedTypes) {
        ArrayList matches = new ArrayList();
        if (!this.hasGeneratorsForRawClass(token.getRawClass())) {
            this.maybeAddLambdaGenerator(token, matches);
        } else {
            this.maybeAddGeneratorsForRawClass(token, allowMixedTypes, matches);
        }
        if (matches.isEmpty()) {
            throw new IllegalArgumentException("Cannot find generator for " + token.getRawClass());
        }
        return matches;
    }

    private void maybeAddLambdaGenerator(org.javaruntype.type.Type<?> token, List<Generator<?>> matches) {
        Method method = Reflection.singleAbstractMethodOf(token.getRawClass());
        if (method != null) {
            LambdaGenerator lambda = new LambdaGenerator(token.getRawClass(), this.generatorFor(GeneratorRepository.token(method.getGenericReturnType()), true));
            matches.add(lambda);
        }
    }

    private void maybeAddGeneratorsForRawClass(org.javaruntype.type.Type<?> token, boolean allowMixedTypes, List<Generator<?>> matches) {
        List<Generator<?>> candidates = this.generatorsForRawClass(token.getRawClass(), allowMixedTypes);
        List typeParameters = token.getTypeParameters();
        if (typeParameters.isEmpty()) {
            matches.addAll(candidates);
        } else {
            for (Generator<?> each : candidates) {
                if (!each.canGenerateForParametersOfTypes(typeParameters)) continue;
                matches.add(each);
            }
        }
    }

    private Generator<?> compose(org.javaruntype.type.Type<?> token, List<Generator<?>> matches) {
        List<Weighted<Generator<?>>> weightings = matches.stream().map(g -> new Weighted<Generator>((Generator)g, 1)).collect(Collectors.toList());
        return this.composeWeighted(token, weightings);
    }

    private Generator<?> composeWeighted(org.javaruntype.type.Type<?> token, List<Weighted<Generator<?>>> matches) {
        ArrayList forComponents = new ArrayList();
        for (TypeParameter typeParameter : token.getTypeParameters()) {
            forComponents.add(this.generatorForTypeParameter(typeParameter));
        }
        for (Weighted weighted : matches) {
            this.applyComponentGenerators((Generator)weighted.item, forComponents);
        }
        return new CompositeGenerator(matches);
    }

    private void applyComponentGenerators(Generator<?> generator, List<Generator<?>> componentGenerators) {
        if (generator.hasComponents()) {
            if (componentGenerators.isEmpty()) {
                ArrayList substitutes = new ArrayList();
                Generator<?> zilch = this.generatorFor(GeneratorRepository.token(Zilch.class), true);
                for (int i = 0; i < generator.numberOfNeededComponents(); ++i) {
                    substitutes.add(zilch);
                }
                generator.addComponentGenerators(substitutes);
            } else {
                generator.addComponentGenerators(componentGenerators);
            }
        }
    }

    private Generator<?> generatorForTypeParameter(TypeParameter<?> parameter) {
        if (parameter instanceof StandardTypeParameter) {
            return this.generatorFor(parameter.getType(), true);
        }
        if (parameter instanceof WildcardTypeParameter) {
            return this.generatorFor(GeneratorRepository.token(Zilch.class), true);
        }
        if (parameter instanceof ExtendsTypeParameter) {
            return this.generatorFor(parameter.getType(), false);
        }
        return this.generatorFor(Items.choose(Reflection.supertypes(parameter.getType()), this.random), false);
    }

    private List<Generator<?>> generatorsForRawClass(Class<?> clazz, boolean allowMixedTypes) {
        Set<Generator<?>> matches = this.generators.get(clazz);
        if (!allowMixedTypes) {
            Generator<?> match = Items.choose(matches, this.random);
            matches = new HashSet();
            matches.add(match);
        }
        ArrayList copies = new ArrayList();
        for (Generator<?> each : matches) {
            copies.add(GeneratorRepository.copyOf(each));
        }
        return copies;
    }

    private boolean hasGeneratorsForRawClass(Class<?> clazz) {
        return this.generators.get(clazz) != null;
    }

    private static Generator<?> copyOf(Generator<?> generator) {
        return (Generator)Reflection.instantiate(generator.getClass());
    }

    public static org.javaruntype.type.Type<?> token(Type type) {
        return Types.forJavaLangReflectType((Type)type);
    }
}

