/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.internal.ParameterTypeContext;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.internal.generator.GeneratorRepository;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;

public class Ctor<T>
extends Generator<T> {
    private final Constructor<T> single;
    private final Parameter[] parameters;
    private final List<Generator<?>> parameterGenerators = new ArrayList();

    public Ctor(Class<T> type) {
        super(type);
        this.single = Reflection.singleAccessibleConstructor(type);
        this.parameters = this.single.getParameters();
    }

    @Override
    public T generate(SourceOfRandomness random, GenerationStatus status) {
        return Reflection.instantiate(this.single, this.arguments(random, status));
    }

    @Override
    public boolean canRegisterAsType(Class<?> type) {
        return false;
    }

    private Object[] arguments(SourceOfRandomness random, GenerationStatus status) {
        Object[] args = new Object[this.parameters.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.parameterGenerators.get(i).generate(random, status);
        }
        return args;
    }

    @Override
    public void provideRepository(GeneratorRepository provided) {
        super.provideRepository(provided);
        this.parameterGenerators.clear();
        for (Parameter each : this.parameters) {
            this.parameterGenerators.add(this.generatorFor(this.parameterTypeContext(each)));
        }
    }

    @Override
    public void configure(AnnotatedType annotatedType) {
        super.configure(annotatedType);
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameterGenerators.get(i).configure(this.parameters[i].getAnnotatedType());
        }
    }

    private ParameterTypeContext parameterTypeContext(Parameter parameter) {
        return new ParameterTypeContext(parameter.getName(), parameter.getAnnotatedType(), this.single.getName()).annotate(parameter);
    }
}

