/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal.generator;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.Size;
import com.pholser.junit.quickcheck.internal.Ranges;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.internal.generator.GeneratorRepository;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;

public class ArrayGenerator
extends Generator<Object> {
    private final Class<?> componentType;
    private final Generator<?> component;
    private Size lengthRange;

    public ArrayGenerator(Class<?> componentType, Generator<?> component) {
        super(Object.class);
        this.componentType = componentType;
        this.component = component;
    }

    public void configure(Size lengthRange) {
        this.lengthRange = lengthRange;
        Ranges.checkRange(Ranges.Type.INTEGRAL, lengthRange.min(), lengthRange.max());
    }

    @Override
    public Object generate(SourceOfRandomness random, GenerationStatus status) {
        int length = this.length(random, status);
        Object array = Array.newInstance(this.componentType, length);
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, this.component.generate(random, status));
        }
        return array;
    }

    private int length(SourceOfRandomness random, GenerationStatus status) {
        return this.lengthRange != null ? random.nextInt(this.lengthRange.min(), this.lengthRange.max()) : status.size();
    }

    @Override
    public void provideRepository(GeneratorRepository provided) {
        super.provideRepository(provided);
        this.component.provideRepository(provided);
    }

    @Override
    public void configure(AnnotatedType annotatedType) {
        super.configure(annotatedType);
        this.component.configure(Reflection.annotatedComponentTypes(annotatedType).get(0));
    }

    public Generator<?> componentGenerator() {
        return this.component;
    }
}

