/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.GeneratorConfiguration;
import com.pholser.junit.quickcheck.generator.GeneratorConfigurationException;
import com.pholser.junit.quickcheck.generator.Shrink;
import com.pholser.junit.quickcheck.internal.ParameterTypeContext;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.internal.ReflectionException;
import com.pholser.junit.quickcheck.internal.generator.GeneratorRepository;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.javaruntype.type.TypeParameter;
import org.javaruntype.type.Types;
import org.javaruntype.type.WildcardTypeParameter;

public abstract class Generator<T>
implements Shrink<T> {
    private final List<Class<T>> types = new ArrayList<Class<T>>();
    private GeneratorRepository repo;

    protected Generator(Class<T> type) {
        this(Collections.singletonList(type));
    }

    protected Generator(List<Class<T>> types) {
        this.types.addAll(types);
    }

    public List<Class<T>> types() {
        return Collections.unmodifiableList(this.types);
    }

    public boolean canRegisterAsType(Class<?> type) {
        return true;
    }

    public abstract T generate(SourceOfRandomness var1, GenerationStatus var2);

    @Override
    public final List<T> shrink(SourceOfRandomness random, Object larger) {
        if (!this.canShrink(larger)) {
            throw new IllegalStateException(this.getClass() + " not capable of shrinking " + larger);
        }
        return this.doShrink(random, this.narrow(larger));
    }

    public boolean canShrink(Object larger) {
        return this.types().get(0).isInstance(larger);
    }

    public List<T> doShrink(SourceOfRandomness random, T larger) {
        return Collections.emptyList();
    }

    protected final T narrow(Object wider) {
        return this.types().get(0).cast(wider);
    }

    public boolean hasComponents() {
        return false;
    }

    public int numberOfNeededComponents() {
        return 0;
    }

    public void addComponentGenerators(List<Generator<?>> newComponents) {
    }

    public boolean canGenerateForParametersOfTypes(List<TypeParameter<?>> typeParameters) {
        return true;
    }

    public static boolean compatibleWithTypeParameter(TypeParameter<?> parameter, Class<?> clazz) {
        return parameter instanceof WildcardTypeParameter || parameter.getType().isAssignableFrom(Types.forJavaLangReflectType(clazz));
    }

    public void configure(AnnotatedType annotatedType) {
        List<Annotation> configs = Generator.configurationAnnotationsOn(annotatedType);
        HashMap<Class<? extends Annotation>, Annotation> byType = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation each : configs) {
            byType.put(each.annotationType(), each);
        }
        this.configure(byType);
    }

    private void configure(Map<Class<? extends Annotation>, Annotation> byType) {
        for (Map.Entry<Class<? extends Annotation>, Annotation> each : byType.entrySet()) {
            this.configure(each.getKey(), each.getValue());
        }
    }

    private void configure(Class<? extends Annotation> annotationType, Annotation configuration) {
        Method configurer;
        try {
            configurer = Reflection.findMethod(this.getClass(), "configure", annotationType);
        }
        catch (ReflectionException ex) {
            throw new GeneratorConfigurationException(String.format("Generator %s does not understand configuration annotation %s", this.getClass().getName(), annotationType.getName()), ex);
        }
        Reflection.invoke(configurer, this, configuration);
    }

    public void provideRepository(GeneratorRepository provided) {
        this.repo = provided;
    }

    Generator<?> generatorFor(ParameterTypeContext parameter) {
        return this.repo.produceGenerator(parameter);
    }

    protected static List<Annotation> configurationAnnotationsOn(AnnotatedType annotatedType) {
        return Reflection.allAnnotations(annotatedType).stream().filter(a -> a.annotationType().isAnnotationPresent(GeneratorConfiguration.class)).collect(Collectors.toList());
    }
}

