/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Random;

public final class Lambdas {
    private static Constructor<MethodHandles.Lookup> methodLookupCtor = Reflection.findDeclaredConstructor(MethodHandles.Lookup.class, Class.class, Integer.TYPE);

    private Lambdas() {
        throw new UnsupportedOperationException();
    }

    public static <T, U> T makeLambda(Class<T> lambdaType, Generator<U> returnValueGenerator, GenerationStatus status) {
        if (Reflection.singleAbstractMethodOf(lambdaType) == null) {
            throw new IllegalArgumentException(lambdaType + " is not a functional interface type");
        }
        return lambdaType.cast(Proxy.newProxyInstance(lambdaType.getClassLoader(), new Class[]{lambdaType}, new LambdaInvocationHandler<T, U>(lambdaType, returnValueGenerator, status)));
    }

    private static class LambdaInvocationHandler<T, U>
    implements InvocationHandler {
        private final Class<T> lambdaType;
        private final Generator<U> returnValueGenerator;
        private final GenerationStatus status;

        LambdaInvocationHandler(Class<T> lambdaType, Generator<U> returnValueGenerator, GenerationStatus status) {
            this.lambdaType = lambdaType;
            this.returnValueGenerator = returnValueGenerator;
            this.status = status;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (Object.class.equals(method.getDeclaringClass())) {
                return this.handleObjectMethod(proxy, method, args);
            }
            if (method.isDefault()) {
                return this.handleDefaultMethod(proxy, method, args);
            }
            SourceOfRandomness source = new SourceOfRandomness(new Random());
            source.setSeed(Arrays.hashCode(args));
            return this.returnValueGenerator.generate(source, this.status);
        }

        private Object handleObjectMethod(Object proxy, Method method, Object[] args) {
            if ("equals".equals(method.getName())) {
                return proxy == args[0];
            }
            if ("hashCode".equals(method.getName())) {
                return System.identityHashCode(proxy);
            }
            return this.handleToString();
        }

        private String handleToString() {
            return "a randomly generated instance of " + this.lambdaType;
        }

        private Object handleDefaultMethod(Object proxy, Method method, Object[] args) throws Throwable {
            MethodHandles.Lookup lookup = (MethodHandles.Lookup)methodLookupCtor.newInstance(method.getDeclaringClass(), 2);
            return lookup.unreflectSpecial(method, method.getDeclaringClass()).bindTo(proxy).invokeWithArguments(args);
        }
    }
}

