/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal;

import com.pholser.junit.quickcheck.From;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.internal.Items;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.internal.Weighted;
import com.pholser.junit.quickcheck.internal.Zilch;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.javaruntype.type.ExtendsTypeParameter;
import org.javaruntype.type.StandardTypeParameter;
import org.javaruntype.type.TypeParameter;
import org.javaruntype.type.Types;
import org.javaruntype.type.WildcardTypeParameter;

public class ParameterTypeContext {
    private static final String EXPLICIT_GENERATOR_TYPE_MISMATCH_MESSAGE = "The generator %s named in @%s on parameter %s does not produce a type-compatible object";
    private static Zilch zilch;
    private final String parameterName;
    private final AnnotatedType parameterType;
    private final String declarerName;
    private final org.javaruntype.type.Type<?> token;
    private final List<Weighted<Generator<?>>> explicits = new ArrayList();
    private final Map<String, org.javaruntype.type.Type<?>> typeVariables;
    private boolean allowMixedTypes;

    public ParameterTypeContext(String parameterName, AnnotatedType parameterType, String declarerName) {
        this(parameterName, parameterType, declarerName, Collections.emptyMap());
    }

    public ParameterTypeContext(String parameterName, AnnotatedType parameterType, String declarerName, Map<String, Type> typeVariables) {
        this(parameterName, parameterType, declarerName, Types.forJavaLangReflectType((Type)parameterType.getType(), ParameterTypeContext.toTokens(typeVariables)), ParameterTypeContext.toTokens(typeVariables));
    }

    public ParameterTypeContext(String parameterName, AnnotatedType parameterType, String declarerName, org.javaruntype.type.Type<?> token, Map<String, org.javaruntype.type.Type<?>> typeVariables) {
        this.parameterName = parameterName;
        this.parameterType = parameterType;
        this.declarerName = declarerName;
        this.token = token;
        this.typeVariables = typeVariables;
    }

    private static Map<String, org.javaruntype.type.Type<?>> toTokens(Map<String, Type> typeVariables) {
        return typeVariables.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Types.forJavaLangReflectType((Type)((Type)e.getValue()))));
    }

    public ParameterTypeContext annotate(AnnotatedElement element) {
        List<From> generators = Reflection.allAnnotationsByType(element, From.class);
        if (!generators.isEmpty() && element instanceof AnnotatedWildcardType) {
            throw new IllegalArgumentException("Wildcards cannot be marked with @From");
        }
        this.addGenerators(generators);
        return this;
    }

    public ParameterTypeContext allowMixedTypes(boolean value) {
        this.allowMixedTypes = value;
        return this;
    }

    public boolean allowMixedTypes() {
        return this.allowMixedTypes;
    }

    private void addGenerators(List<From> generators) {
        for (From each : generators) {
            Generator<?> generator = this.makeGenerator(each.value());
            this.ensureCorrectType(generator);
            this.explicits.add(new Weighted(generator, each.frequency()));
        }
    }

    private Generator<?> makeGenerator(Class<? extends Generator> generatorType) {
        Constructor<? extends Generator> ctor = Reflection.findConstructor(generatorType, Class.class);
        if (ctor != null) {
            return Reflection.instantiate(ctor, this.rawParameterType());
        }
        return Reflection.instantiate(generatorType);
    }

    private Class<?> rawParameterType() {
        if (this.type() instanceof ParameterizedType) {
            return (Class)((ParameterizedType)this.type()).getRawType();
        }
        return (Class)this.type();
    }

    private void ensureCorrectType(Generator<?> generator) {
        org.javaruntype.type.Type parameterTypeToken = Types.forJavaLangReflectType((Type)this.type(), this.typeVariables);
        for (Class<?> each : generator.types()) {
            if (Reflection.maybeWrap(parameterTypeToken.getRawClass()).isAssignableFrom(Reflection.maybeWrap(each))) continue;
            throw new IllegalArgumentException(String.format(EXPLICIT_GENERATOR_TYPE_MISMATCH_MESSAGE, each, From.class.getName(), this.parameterName));
        }
    }

    public String name() {
        return this.declarerName + ':' + this.parameterName;
    }

    public AnnotatedType annotatedType() {
        return this.parameterType;
    }

    public Type type() {
        return this.parameterType.getType();
    }

    public List<Weighted<Generator<?>>> explicitGenerators() {
        return Collections.unmodifiableList(this.explicits);
    }

    public boolean annotatedWith(Class<? extends Annotation> annotationType) {
        return this.parameterType.getAnnotation(annotationType) != null;
    }

    public boolean isArray() {
        return this.token.isArray();
    }

    public ParameterTypeContext arrayComponentContext() {
        org.javaruntype.type.Type component = Types.arrayComponentOf(this.token);
        AnnotatedType annotatedComponent = ((AnnotatedArrayType)this.parameterType).getAnnotatedGenericComponentType();
        return new ParameterTypeContext(annotatedComponent.getType().getTypeName(), annotatedComponent, this.parameterType.getType().getTypeName(), component, this.typeVariables).annotate(annotatedComponent).allowMixedTypes(true);
    }

    public Class<?> getRawClass() {
        return this.token.getRawClass();
    }

    public boolean isEnum() {
        return this.getRawClass().isEnum();
    }

    public List<TypeParameter<?>> getTypeParameters() {
        return this.token.getTypeParameters();
    }

    public List<ParameterTypeContext> typeParameterContexts(SourceOfRandomness random) {
        ArrayList<ParameterTypeContext> typeParameterContexts = new ArrayList<ParameterTypeContext>();
        List<TypeParameter<?>> typeParameters = this.getTypeParameters();
        List<AnnotatedType> annotatedTypeParameters = Reflection.annotatedComponentTypes(this.annotatedType());
        for (int i = 0; i < typeParameters.size(); ++i) {
            AnnotatedType a;
            TypeParameter<?> p = typeParameters.get(i);
            AnnotatedType annotatedType = a = annotatedTypeParameters.size() > i ? annotatedTypeParameters.get(i) : ParameterTypeContext.zilch();
            if (p instanceof StandardTypeParameter) {
                typeParameterContexts.add(new ParameterTypeContext(p.getType().getName(), a, this.annotatedType().getType().getTypeName(), p.getType(), this.typeVariables).allowMixedTypes(!(a instanceof TypeVariable)).annotate(a));
                continue;
            }
            if (p instanceof WildcardTypeParameter) {
                typeParameterContexts.add(new ParameterTypeContext("Zilch", a, this.annotatedType().getType().getTypeName(), Types.forJavaLangReflectType(Zilch.class), this.typeVariables).allowMixedTypes(true).annotate(a));
                continue;
            }
            if (p instanceof ExtendsTypeParameter) {
                typeParameterContexts.add(new ParameterTypeContext(p.getType().getName(), Reflection.annotatedComponentTypes(a).get(0), this.annotatedType().getType().getTypeName(), p.getType(), this.typeVariables).allowMixedTypes(false).annotate(a));
                continue;
            }
            Set<org.javaruntype.type.Type<?>> supertypes = Reflection.supertypes(p.getType());
            org.javaruntype.type.Type<?> choice = Items.choose(supertypes, random);
            typeParameterContexts.add(new ParameterTypeContext(p.getType().getName(), Reflection.annotatedComponentTypes(a).get(0), this.annotatedType().getType().getTypeName(), choice, this.typeVariables).allowMixedTypes(false).annotate(a));
        }
        return typeParameterContexts;
    }

    private static AnnotatedType zilch() {
        try {
            return ParameterTypeContext.class.getDeclaredField("zilch").getAnnotatedType();
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }
}

