/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal.generator;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.GeneratorConfigurationException;
import com.pholser.junit.quickcheck.internal.Items;
import com.pholser.junit.quickcheck.internal.Weighted;
import com.pholser.junit.quickcheck.internal.generator.GeneratorRepository;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class CompositeGenerator
extends Generator<Object> {
    private final List<Weighted<Generator<?>>> composed;

    public CompositeGenerator(List<Weighted<Generator<?>>> composed) {
        super(Object.class);
        this.composed = new ArrayList(composed);
    }

    @Override
    public Object generate(SourceOfRandomness random, GenerationStatus status) {
        Generator choice = (Generator)Items.chooseWeighted(this.composed, random);
        return choice.generate(random, status);
    }

    @Override
    public boolean canShrink(Object larger) {
        return this.composed.stream().map(w -> (Generator)w.item).anyMatch(g -> g.canShrink(larger));
    }

    @Override
    public List<Object> doShrink(SourceOfRandomness random, Object larger) {
        List shrinkers = this.composed.stream().filter(w -> ((Generator)w.item).canShrink(larger)).collect(Collectors.toList());
        Generator choice = (Generator)Items.chooseWeighted(shrinkers, random);
        return new ArrayList<Object>(choice.shrink(random, larger));
    }

    public Generator<?> composed(int index) {
        return (Generator)this.composed.get((int)index).item;
    }

    public int numberOfComposedGenerators() {
        return this.composed.size();
    }

    @Override
    public void provideRepository(GeneratorRepository provided) {
        super.provideRepository(provided);
        for (Weighted<Generator<?>> each : this.composed) {
            ((Generator)each.item).provideRepository(provided);
        }
    }

    @Override
    public void configure(AnnotatedType annotatedType) {
        Iterator<Weighted<Generator<?>>> it = this.composed.iterator();
        while (it.hasNext()) {
            try {
                ((Generator)it.next().item).configure(annotatedType);
            }
            catch (GeneratorConfigurationException e) {
                it.remove();
            }
        }
        if (this.composed.isEmpty()) {
            throw new GeneratorConfigurationException(String.format("No generator that can produce values of type %s understands all of the configuration annotations %s", annotatedType.getType().getTypeName(), CompositeGenerator.configurationAnnotationNames(annotatedType)));
        }
    }

    private static List<String> configurationAnnotationNames(AnnotatedType annotatedType) {
        return CompositeGenerator.configurationAnnotationsOn(annotatedType).stream().map(a -> a.annotationType().getName()).collect(Collectors.toList());
    }
}

