/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.runner;

import com.pholser.junit.quickcheck.Property;
import com.pholser.junit.quickcheck.internal.GeometricDistribution;
import com.pholser.junit.quickcheck.internal.generator.GeneratorRepository;
import com.pholser.junit.quickcheck.internal.generator.ServiceLoaderGeneratorSource;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import com.pholser.junit.quickcheck.runner.PropertyStatement;
import java.util.List;
import java.util.Random;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnitQuickcheck
extends BlockJUnit4ClassRunner {
    private final GeneratorRepository repo;
    private final GeometricDistribution distro;
    private final Logger seedLog;

    public JUnitQuickcheck(Class<?> clazz) throws InitializationError {
        super(clazz);
        SourceOfRandomness random = new SourceOfRandomness(new Random());
        this.repo = new GeneratorRepository(random).register(new ServiceLoaderGeneratorSource());
        this.distro = new GeometricDistribution();
        this.seedLog = LoggerFactory.getLogger((String)"junit-quickcheck.seed-reporting");
    }

    protected void validateTestMethods(List<Throwable> errors) {
        for (FrameworkMethod each : this.computeTestMethods()) {
            each.validatePublicVoid(false, errors);
        }
    }

    protected List<FrameworkMethod> computeTestMethods() {
        return this.getTestClass().getAnnotatedMethods(Property.class);
    }

    public Statement methodBlock(FrameworkMethod method) {
        return new PropertyStatement(method, this.getTestClass(), this.repo, this.distro, this.seedLog);
    }
}

