/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.runner;

import com.pholser.junit.quickcheck.internal.generator.PropertyParameterGenerationContext;
import com.pholser.junit.quickcheck.runner.ShrinkNode;
import java.util.List;
import java.util.Stack;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

class Shrinker {
    private final FrameworkMethod method;
    private final TestClass testClass;
    private final AssertionError failure;
    private final int maxShrinks;
    private final int maxShrinkDepth;
    private int shrinkAttempts;

    Shrinker(FrameworkMethod method, TestClass testClass, AssertionError failure, int maxShrinks, int maxShrinkDepth) {
        this.method = method;
        this.testClass = testClass;
        this.failure = failure;
        this.maxShrinks = maxShrinks;
        this.maxShrinkDepth = maxShrinkDepth;
    }

    void shrink(List<PropertyParameterGenerationContext> params, Object[] args) throws Throwable {
        Stack<ShrinkNode> nodes = new Stack<ShrinkNode>();
        ShrinkNode smallestFailure = ShrinkNode.root(this.method, this.testClass, params, args);
        smallestFailure.shrinks().forEach(nodes::push);
        while (this.shouldContinueShrinking(nodes)) {
            ShrinkNode next = nodes.pop();
            if (!next.mightBePast(smallestFailure)) continue;
            boolean result = next.verifyProperty();
            ++this.shrinkAttempts;
            if (!result) {
                smallestFailure = next;
                List<ShrinkNode> shrinks = next.shrinks();
                if (shrinks.isEmpty()) {
                    smallestFailure = smallestFailure.advanceToNextArg();
                } else {
                    shrinks.forEach(nodes::push);
                }
            }
            if (!nodes.empty()) continue;
            smallestFailure = smallestFailure.advanceToNextArg();
            smallestFailure.shrinks().forEach(nodes::push);
        }
        throw smallestFailure.fail(this.failure);
    }

    private boolean shouldContinueShrinking(Stack<ShrinkNode> nodes) {
        return this.shrinkAttempts < this.maxShrinks && !nodes.empty() && !nodes.peek().deeperThan(this.maxShrinkDepth);
    }
}

