/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal.generator;

import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.internal.GeometricDistribution;
import com.pholser.junit.quickcheck.internal.PropertyParameterContext;
import com.pholser.junit.quickcheck.internal.constraint.ConstraintEvaluator;
import com.pholser.junit.quickcheck.internal.generator.AbstractGenerationStatus;
import com.pholser.junit.quickcheck.internal.generator.GeneratorRepository;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;

public class PropertyParameterGenerationContext
extends AbstractGenerationStatus {
    private final PropertyParameterContext parameter;
    private final ConstraintEvaluator evaluator;
    private final Generator<?> generator;
    private int successfulEvaluations;
    private int discards;

    public PropertyParameterGenerationContext(PropertyParameterContext parameter, GeneratorRepository repository, GeometricDistribution distro, SourceOfRandomness random, Logger seedLog) {
        super(distro, PropertyParameterGenerationContext.initializeRandomness(parameter, random, seedLog));
        this.parameter = parameter;
        this.evaluator = new ConstraintEvaluator(parameter.constraint());
        this.generator = repository.produceGenerator(parameter.typeContext());
    }

    private static SourceOfRandomness initializeRandomness(PropertyParameterContext p, SourceOfRandomness r, Logger seedLog) {
        if (p.fixedSeed()) {
            r.setSeed(p.seed());
        }
        seedLog.debug("Seed for parameter {} is {}", (Object)p.typeContext().name(), (Object)r.seed());
        return r;
    }

    public Object generate() {
        Object nextValue = this.generator.generate(this.random, this);
        while (!this.evaluate(nextValue)) {
            nextValue = this.generator.generate(this.random, this);
        }
        return nextValue;
    }

    public List<Object> shrink(Object larger) {
        return this.generator.canShrink(larger) ? new ArrayList(this.generator.shrink(this.random, larger)) : Collections.emptyList();
    }

    private boolean evaluate(Object value) {
        this.evaluator.bind(value);
        boolean result = this.evaluator.evaluate();
        if (result) {
            ++this.successfulEvaluations;
        } else {
            ++this.discards;
        }
        if (this.tooManyDiscards()) {
            throw new DiscardRatioExceededException(this.parameter, this.discards, this.successfulEvaluations);
        }
        return result;
    }

    private boolean tooManyDiscards() {
        if (this.parameter.discardRatio() == 0) {
            return this.discards > this.parameter.sampleSize();
        }
        return this.successfulEvaluations == 0 ? this.discards > this.parameter.discardRatio() : this.discards / this.successfulEvaluations >= this.parameter.discardRatio();
    }

    @Override
    public int size() {
        int sample = super.size();
        return Math.min(sample, this.parameter.sampleSize());
    }

    @Override
    public int attempts() {
        return this.successfulEvaluations + this.discards;
    }

    public static class DiscardRatioExceededException
    extends RuntimeException {
        static final String MESSAGE_TEMPLATE = "For parameter [%s] with discard ratio [%d], %d unsuccessful values and %d successes for a discard ratio of [%f]. Stopping.";
        private static final long serialVersionUID = Long.MIN_VALUE;

        DiscardRatioExceededException(PropertyParameterContext parameter, int discards, int successfulEvaluations) {
            super(String.format(MESSAGE_TEMPLATE, parameter.typeContext().name(), parameter.discardRatio(), discards, successfulEvaluations, (double)discards / (double)successfulEvaluations));
        }
    }
}

