/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.runner;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.junit.AssumptionViolatedException;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

class PropertyVerifier
extends BlockJUnit4ClassRunner {
    private final FrameworkMethod method;
    private final Object[] args;
    private final Consumer<Void> onSuccess;
    private final Consumer<AssumptionViolatedException> onAssumptionViolated;
    private final Consumer<AssertionError> onFailure;

    PropertyVerifier(TestClass clazz, FrameworkMethod method, Object[] args, Consumer<Void> onSuccess, Consumer<AssumptionViolatedException> onAssumptionViolated, Consumer<AssertionError> onFailure) throws InitializationError {
        super(clazz.getJavaClass());
        this.method = method;
        this.args = args;
        this.onSuccess = onSuccess;
        this.onAssumptionViolated = onAssumptionViolated;
        this.onFailure = onFailure;
    }

    void verify() throws Throwable {
        this.methodBlock().evaluate();
    }

    private Statement methodBlock() {
        final Statement statement = super.methodBlock(this.method);
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    statement.evaluate();
                    PropertyVerifier.this.onSuccess.accept(null);
                }
                catch (AssumptionViolatedException e) {
                    PropertyVerifier.this.onAssumptionViolated.accept(e);
                }
                catch (AssertionError e) {
                    PropertyVerifier.this.onFailure.accept(e);
                }
                catch (Throwable e) {
                    PropertyVerifier.this.reportErrorWithArguments(e);
                }
            }
        };
    }

    protected void collectInitializationErrors(List<Throwable> errors) {
    }

    protected Statement methodInvoker(final FrameworkMethod frameworkMethod, final Object test) {
        return new Statement(){

            public void evaluate() throws Throwable {
                frameworkMethod.invokeExplosively(test, PropertyVerifier.this.args);
            }
        };
    }

    private void reportErrorWithArguments(Throwable e) {
        throw new AssertionError(String.format("Unexpected error in property %s with args %s", this.method.getName(), Arrays.asList(this.args)), e);
    }
}

