/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.runner;

import com.pholser.junit.quickcheck.internal.generator.PropertyParameterGenerationContext;
import com.pholser.junit.quickcheck.runner.PropertyVerifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;

final class ShrinkNode {
    private final FrameworkMethod method;
    private final TestClass testClass;
    private final List<PropertyParameterGenerationContext> params;
    private final Object[] args;
    private final int argIndex;
    private final int depth;

    private ShrinkNode(FrameworkMethod method, TestClass testClass, List<PropertyParameterGenerationContext> params, Object[] args, int argIndex, int depth) {
        this.method = method;
        this.testClass = testClass;
        this.params = params;
        this.args = args;
        this.argIndex = argIndex;
        this.depth = depth;
    }

    static ShrinkNode root(FrameworkMethod method, TestClass testClass, List<PropertyParameterGenerationContext> params, Object[] args) {
        return new ShrinkNode(method, testClass, params, args, 0, 0);
    }

    List<ShrinkNode> shrinks() {
        if (this.argIndex >= this.args.length) {
            return Collections.emptyList();
        }
        PropertyParameterGenerationContext param = this.params.get(this.argIndex);
        return param.shrink(this.args[this.argIndex]).stream().map(this::shrinkNodeFor).collect(Collectors.toList());
    }

    boolean verifyProperty() throws Throwable {
        boolean[] result = new boolean[1];
        this.property(result).verify();
        return result[0];
    }

    ShrinkNode advanceToNextArg() {
        return new ShrinkNode(this.method, this.testClass, this.params, this.args, this.argIndex + 1, this.depth);
    }

    AssertionError fail(AssertionError originalFailure) {
        AssertionError minimumFailure = new AssertionError((Object)String.format("Property %s falsified for args shrunken to %s", this.method.getName(), Arrays.asList(this.args)));
        ((Throwable)((Object)minimumFailure)).setStackTrace(((Throwable)((Object)originalFailure)).getStackTrace());
        throw minimumFailure;
    }

    boolean mightBePast(ShrinkNode other) {
        return this.argIndex >= other.argIndex && this.depth >= other.depth;
    }

    boolean deeperThan(int max) {
        return this.depth > max;
    }

    private PropertyVerifier property(boolean[] result) throws InitializationError {
        return new PropertyVerifier(this.testClass, this.method, this.args, s -> {
            result[0] = true;
        }, v -> {
            result[0] = true;
        }, e -> {
            result[0] = false;
        });
    }

    private ShrinkNode shrinkNodeFor(Object shrunk) {
        Object[] shrunkArgs = new Object[this.args.length];
        System.arraycopy(this.args, 0, shrunkArgs, 0, this.args.length);
        shrunkArgs[this.argIndex] = shrunk;
        return new ShrinkNode(this.method, this.testClass, this.params, shrunkArgs, this.argIndex, this.depth + 1);
    }
}

