/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;

class FakeAnnotatedTypeFactory {
    private FakeAnnotatedTypeFactory() {
        throw new UnsupportedOperationException();
    }

    static AnnotatedType makeFrom(Class<?> clazz) {
        return clazz.isArray() ? FakeAnnotatedTypeFactory.makeArrayType(clazz) : FakeAnnotatedTypeFactory.makePlainType(clazz);
    }

    private static AnnotatedArrayType makeArrayType(final Class<?> type) {
        return new AnnotatedArrayType(){

            @Override
            public AnnotatedType getAnnotatedGenericComponentType() {
                return FakeAnnotatedTypeFactory.makeFrom(type.getComponentType());
            }

            @Override
            public Type getType() {
                return type;
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return null;
            }

            @Override
            public Annotation[] getAnnotations() {
                return new Annotation[0];
            }

            @Override
            public Annotation[] getDeclaredAnnotations() {
                return new Annotation[0];
            }
        };
    }

    private static AnnotatedType makePlainType(final Class<?> type) {
        return new AnnotatedType(){

            @Override
            public Type getType() {
                return type;
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return null;
            }

            @Override
            public Annotation[] getAnnotations() {
                return new Annotation[0];
            }

            @Override
            public Annotation[] getDeclaredAnnotations() {
                return new Annotation[0];
            }
        };
    }
}

