/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.runner;

import com.pholser.junit.quickcheck.Property;
import com.pholser.junit.quickcheck.internal.GeometricDistribution;
import com.pholser.junit.quickcheck.internal.generator.GeneratorRepository;
import com.pholser.junit.quickcheck.internal.generator.ServiceLoaderGeneratorSource;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import com.pholser.junit.quickcheck.runner.JUnitQuickcheckTestClass;
import com.pholser.junit.quickcheck.runner.PropertyStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.Test;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class JUnitQuickcheck
extends BlockJUnit4ClassRunner {
    private final GeneratorRepository repo;
    private final GeometricDistribution distro;

    public JUnitQuickcheck(Class<?> clazz) throws InitializationError {
        super(clazz);
        SourceOfRandomness random = new SourceOfRandomness(new Random());
        this.repo = new GeneratorRepository(random).register(new ServiceLoaderGeneratorSource());
        this.distro = new GeometricDistribution();
    }

    protected void validateTestMethods(List<Throwable> errors) {
        this.validatePublicVoidNoArgMethods(Test.class, false, errors);
        this.validatePropertyMethods(errors);
    }

    private void validatePropertyMethods(List<Throwable> errors) {
        for (FrameworkMethod each : this.getTestClass().getAnnotatedMethods(Property.class)) {
            each.validatePublicVoid(false, errors);
        }
    }

    protected List<FrameworkMethod> computeTestMethods() {
        ArrayList<FrameworkMethod> methods = new ArrayList<FrameworkMethod>();
        methods.addAll(this.getTestClass().getAnnotatedMethods(Test.class));
        methods.addAll(this.getTestClass().getAnnotatedMethods(Property.class));
        return methods;
    }

    public Statement methodBlock(FrameworkMethod method) {
        return method.getAnnotation(Test.class) != null ? super.methodBlock(method) : new PropertyStatement(method, this.getTestClass(), this.repo, this.distro);
    }

    protected TestClass createTestClass(Class<?> testClass) {
        return new JUnitQuickcheckTestClass(testClass);
    }
}

