/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.runner;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.internal.MethodSorter;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMember;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

class JUnitQuickcheckTestClass
extends TestClass {
    JUnitQuickcheckTestClass(Class<?> testClass) {
        super(testClass);
    }

    protected void scanAnnotatedMembers(Map<Class<? extends Annotation>, List<FrameworkMethod>> methodsForAnnotations, Map<Class<? extends Annotation>, List<FrameworkField>> fieldsForAnnotations) {
        super.scanAnnotatedMembers(methodsForAnnotations, fieldsForAnnotations);
        this.addDefaultInterfaceMethods(methodsForAnnotations);
    }

    private void addDefaultInterfaceMethods(Map<Class<? extends Annotation>, List<FrameworkMethod>> methodsForAnnotations) {
        for (Class<?> each : this.implementedInterfaces()) {
            this.addDefaultInterfaceMethodsFrom(methodsForAnnotations, each);
        }
    }

    private void addDefaultInterfaceMethodsFrom(Map<Class<? extends Annotation>, List<FrameworkMethod>> methodsForAnnotations, Class<?> iface) {
        List defaultMethods = Arrays.stream(MethodSorter.getDeclaredMethods(iface)).filter(Method::isDefault).collect(Collectors.toList());
        for (Method each : defaultMethods) {
            JUnitQuickcheckTestClass.addToAnnotationLists((FrameworkMember)new FrameworkMethod(each), methodsForAnnotations);
        }
    }

    private Set<Class<?>> implementedInterfaces() {
        HashSet interfaces = new HashSet();
        for (Class c = this.getJavaClass(); c != null; c = c.getSuperclass()) {
            Collections.addAll(interfaces, c.getInterfaces());
        }
        return interfaces;
    }
}

