/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.runner;

import com.pholser.junit.quickcheck.Property;
import com.pholser.junit.quickcheck.internal.GeometricDistribution;
import com.pholser.junit.quickcheck.internal.ParameterSampler;
import com.pholser.junit.quickcheck.internal.ParameterTypeContext;
import com.pholser.junit.quickcheck.internal.PropertyParameterContext;
import com.pholser.junit.quickcheck.internal.SeededValue;
import com.pholser.junit.quickcheck.internal.ShrinkControl;
import com.pholser.junit.quickcheck.internal.generator.GeneratorRepository;
import com.pholser.junit.quickcheck.internal.generator.PropertyParameterGenerationContext;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import com.pholser.junit.quickcheck.runner.PropertyFalsified;
import com.pholser.junit.quickcheck.runner.PropertyVerifier;
import com.pholser.junit.quickcheck.runner.Shrinker;
import com.pholser.junit.quickcheck.runner.sampling.ExhaustiveParameterSampler;
import com.pholser.junit.quickcheck.runner.sampling.TupleParameterSampler;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.AssumptionViolatedException;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import ru.vyarus.java.generics.resolver.GenericsResolver;

class PropertyStatement
extends Statement {
    private final FrameworkMethod method;
    private final TestClass testClass;
    private final GeneratorRepository repo;
    private final GeometricDistribution distro;
    private final List<AssumptionViolatedException> assumptionViolations = new ArrayList<AssumptionViolatedException>();
    private int successes;

    PropertyStatement(FrameworkMethod method, TestClass testClass, GeneratorRepository repo, GeometricDistribution distro) {
        this.method = method;
        this.testClass = testClass;
        this.repo = repo;
        this.distro = distro;
    }

    public void evaluate() throws Throwable {
        Map typeVariables = GenericsResolver.resolve((Class)this.testClass.getJavaClass(), (Class[])new Class[0]).method(this.method.getMethod()).genericsMap();
        Property marker = (Property)this.method.getAnnotation(Property.class);
        ParameterSampler sampler = this.sampler(marker);
        ShrinkControl shrinkControl = new ShrinkControl(marker);
        List<PropertyParameterGenerationContext> parameters = Arrays.stream(this.method.getMethod().getParameters()).map(p -> this.parameterContextFor((Parameter)p, sampler, typeVariables)).map(p -> new PropertyParameterGenerationContext((PropertyParameterContext)p, this.repo, this.distro, new SourceOfRandomness(new Random()))).collect(Collectors.toList());
        Stream<List<SeededValue>> sample = sampler.sample(parameters);
        for (List args : sample::iterator) {
            this.property(args, shrinkControl).verify();
        }
        if (this.successes == 0 && !this.assumptionViolations.isEmpty()) {
            Assert.fail((String)("No values satisfied property assumptions. Violated assumptions: " + this.assumptionViolations));
        }
    }

    private PropertyVerifier property(List<SeededValue> arguments, ShrinkControl shrinkControl) throws InitializationError {
        List params = arguments.stream().map(SeededValue::parameter).collect(Collectors.toList());
        Object[] args = arguments.stream().map(SeededValue::value).toArray();
        long[] seeds = arguments.stream().mapToLong(SeededValue::seed).toArray();
        return new PropertyVerifier(this.testClass, this.method, args, seeds, s -> ++this.successes, this.assumptionViolations::add, (e, action) -> {
            if (!shrinkControl.shouldShrink()) {
                shrinkControl.onMinimalCounterexample().handle(args, (Runnable)action);
                throw PropertyFalsified.counterexampleFound(this.method.getName(), args, seeds, e);
            }
            try {
                this.shrink(params, args, seeds, shrinkControl, (AssertionError)e);
            }
            catch (AssertionError ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new AssertionError((Object)ex);
            }
        });
    }

    private void shrink(List<PropertyParameterGenerationContext> params, Object[] args, long[] seeds, ShrinkControl shrinkControl, AssertionError failure) throws Throwable {
        new Shrinker(this.method, this.testClass, failure, shrinkControl).shrink(params, args, seeds);
    }

    private PropertyParameterContext parameterContextFor(Parameter parameter, ParameterSampler sampler, Map<String, Type> typeVariables) {
        return new PropertyParameterContext(new ParameterTypeContext(parameter.getName(), parameter.getAnnotatedType(), PropertyStatement.declarerName(parameter), typeVariables).allowMixedTypes(true), sampler.sizeFactor(parameter)).annotate(parameter);
    }

    private ParameterSampler sampler(Property marker) {
        switch (marker.mode()) {
            case SAMPLING: {
                return new TupleParameterSampler(marker.trials());
            }
            case EXHAUSTIVE: {
                return new ExhaustiveParameterSampler(marker.trials());
            }
        }
        throw new AssertionError((Object)("Don't recognize mode " + (Object)((Object)marker.mode())));
    }

    private static String declarerName(Parameter p) {
        Executable exec = p.getDeclaringExecutable();
        return exec.getDeclaringClass().getName() + '.' + exec.getName();
    }
}

