/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.runner.sampling;

import com.pholser.junit.quickcheck.internal.CartesianIterator;
import com.pholser.junit.quickcheck.internal.ParameterSampler;
import com.pholser.junit.quickcheck.internal.SeededValue;
import com.pholser.junit.quickcheck.internal.generator.PropertyParameterGenerationContext;
import java.lang.reflect.Parameter;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ExhaustiveParameterSampler
implements ParameterSampler {
    private final int sizeFactor;

    public ExhaustiveParameterSampler(int sizeFactor) {
        this.sizeFactor = sizeFactor;
    }

    @Override
    public int sizeFactor(Parameter p) {
        return this.sizeFactor;
    }

    @Override
    public Stream<List<SeededValue>> sample(List<PropertyParameterGenerationContext> parameters) {
        List sources = parameters.stream().map(p -> Stream.generate(() -> new SeededValue((PropertyParameterGenerationContext)p)).limit(p.sampleSize()).iterator()).collect(Collectors.toList());
        return this.cartesian(sources);
    }

    private <T> Stream<List<T>> cartesian(List<Iterator<T>> sources) {
        Iterable cartesian = () -> new CartesianIterator(sources);
        return StreamSupport.stream(cartesian.spliterator(), false);
    }
}

