/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator;

import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.Generators;
import com.pholser.junit.quickcheck.internal.Reflection;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.javaruntype.type.TypeParameter;

public abstract class ComponentizedGenerator<T>
extends Generator<T> {
    private final List<Generator<?>> components = new ArrayList();

    protected ComponentizedGenerator(Class<T> type) {
        super(type);
    }

    @Override
    public boolean canRegisterAsType(Class<?> type) {
        return !Object.class.equals(type);
    }

    @Override
    public final boolean hasComponents() {
        return true;
    }

    @Override
    public void addComponentGenerators(List<Generator<?>> newComponents) {
        if (newComponents.size() != this.numberOfNeededComponents()) {
            throw new IllegalArgumentException(String.format("Needed %d components for %s, but got %d", this.numberOfNeededComponents(), this.getClass(), newComponents.size()));
        }
        this.components.clear();
        this.components.addAll(newComponents);
    }

    @Override
    public boolean canGenerateForParametersOfTypes(List<TypeParameter<?>> typeParameters) {
        return this.numberOfNeededComponents() == typeParameters.size();
    }

    @Override
    public void provide(Generators provided) {
        super.provide(provided);
        for (Generator<?> each : this.components) {
            each.provide(provided);
        }
    }

    @Override
    public void configure(AnnotatedType annotatedType) {
        super.configure(annotatedType);
        List<AnnotatedType> annotatedComponentTypes = Reflection.annotatedComponentTypes(annotatedType);
        if (annotatedComponentTypes.size() == this.components.size()) {
            for (int i = 0; i < this.components.size(); ++i) {
                this.components.get(i).configure(annotatedComponentTypes.get(i));
            }
        }
    }

    protected List<Generator<?>> componentGenerators() {
        return Collections.unmodifiableList(this.components);
    }
}

