/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal.conversion;

import com.pholser.junit.quickcheck.conversion.StringConversion;
import com.pholser.junit.quickcheck.generator.Also;
import com.pholser.junit.quickcheck.generator.Only;
import com.pholser.junit.quickcheck.internal.ParameterTypeContext;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.internal.ReflectionException;
import com.pholser.junit.quickcheck.internal.conversion.ConstructorInvokingStringConversion;
import com.pholser.junit.quickcheck.internal.conversion.MethodInvokingStringConversion;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class StringConversions {
    private StringConversions() {
        throw new UnsupportedOperationException();
    }

    public static StringConversion to(Class<?> clazz) {
        Class<?> wrapped = Reflection.maybeWrap(clazz);
        try {
            Method method = Reflection.findMethod(clazz, "valueOf", String.class);
            if (Modifier.isStatic(method.getModifiers()) && wrapped.equals(method.getReturnType())) {
                return new MethodInvokingStringConversion(method);
            }
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
        if (Character.class.equals(wrapped)) {
            return StringConversions.characterConversion(clazz);
        }
        return new ConstructorInvokingStringConversion(Reflection.findConstructor(wrapped, String.class));
    }

    public static StringConversion decide(ParameterTypeContext p, Only only) {
        return StringConversions.decide(p, only.by(), Only.class);
    }

    public static StringConversion decide(ParameterTypeContext p, Also also) {
        return StringConversions.decide(p, also.by(), Also.class);
    }

    private static <T extends Annotation> StringConversion decide(ParameterTypeContext p, Class<? extends StringConversion> custom, Class<T> markerClass) {
        return custom.equals(Reflection.defaultValueOf(markerClass, "by")) ? StringConversions.to(p.getRawClass()) : Reflection.instantiate(custom);
    }

    private static StringConversion characterConversion(Class<?> clazz) {
        return raw -> {
            if (raw.length() > 1) {
                throw new IllegalArgumentException("Cannot convert " + raw + " into an instance of " + clazz);
            }
            return Character.valueOf(raw.charAt(0));
        };
    }
}

