/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal.generator;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.internal.GeometricDistribution;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

abstract class AbstractGenerationStatus
implements GenerationStatus {
    private final GeometricDistribution distro;
    private final SourceOfRandomness random;
    private final Map<GenerationStatus.Key<?>, Object> contextValues = new HashMap();

    AbstractGenerationStatus(GeometricDistribution distro, SourceOfRandomness random) {
        this.distro = distro;
        this.random = random;
    }

    @Override
    public <T> GenerationStatus setValue(GenerationStatus.Key<T> key, T value) {
        this.contextValues.put(key, value);
        return this;
    }

    @Override
    public <T> Optional<T> valueOf(GenerationStatus.Key<T> key) {
        return Optional.ofNullable(key.cast(this.contextValues.get(key)));
    }

    @Override
    public int size() {
        return this.distro.sampleWithMean(this.attempts() + 1, this.random);
    }

    protected final SourceOfRandomness random() {
        return this.random;
    }
}

