/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.Generators;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Fields<T>
extends Generator<T> {
    private final List<Field> fields;
    private final List<Generator<?>> fieldGenerators = new ArrayList();

    public Fields(Class<T> type) {
        super(type);
        this.fields = Reflection.allDeclaredFieldsOf(type).stream().filter(f -> !Modifier.isFinal(f.getModifiers())).collect(Collectors.toList());
        Reflection.instantiate(type);
    }

    @Override
    public T generate(SourceOfRandomness random, GenerationStatus status) {
        Class type = this.types().get(0);
        Object generated = Reflection.instantiate(type);
        for (int i = 0; i < this.fields.size(); ++i) {
            Reflection.setField(this.fields.get(i), generated, this.fieldGenerators.get(i).generate(random, status), true);
        }
        return type.cast(generated);
    }

    @Override
    public void provide(Generators provided) {
        super.provide(provided);
        this.fieldGenerators.clear();
        for (Field each : this.fields) {
            this.fieldGenerators.add(this.gen().field(each));
        }
    }

    @Override
    public void configure(AnnotatedType annotatedType) {
        super.configure(annotatedType);
        for (int i = 0; i < this.fields.size(); ++i) {
            this.fieldGenerators.get(i).configure(this.fields.get(i).getAnnotatedType());
        }
    }

    @Override
    public Generator<T> copy() {
        return new Fields(this.types().get(0));
    }
}

