/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.runner;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.internal.MethodSorter;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMember;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public class JUnitQuickcheckTestClass
extends TestClass {
    public JUnitQuickcheckTestClass(Class<?> testClass) {
        super(testClass);
    }

    protected void scanAnnotatedMembers(Map<Class<? extends Annotation>, List<FrameworkMethod>> annotatedMethods, Map<Class<? extends Annotation>, List<FrameworkField>> annotatedFields) {
        this.ancestry().forEachOrdered(c -> {
            for (Method each : JUnitQuickcheckTestClass.applicableMethodsOf(c)) {
                JUnitQuickcheckTestClass.addToAnnotationLists((FrameworkMember)new FrameworkMethod(each), (Map)annotatedMethods);
            }
            for (Field each : JUnitQuickcheckTestClass.applicableFieldsOf(c)) {
                JUnitQuickcheckTestClass.addToAnnotationLists((FrameworkMember)this.makeFrameworkField(each), (Map)annotatedFields);
            }
        });
    }

    private FrameworkField makeFrameworkField(Field field) {
        try {
            Constructor ctor = FrameworkField.class.getDeclaredConstructor(Field.class);
            ctor.setAccessible(true);
            return (FrameworkField)ctor.newInstance(field);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Method> applicableMethodsOf(Class<?> clazz) {
        return Arrays.stream(MethodSorter.getDeclaredMethods(clazz)).filter(m -> !m.getDeclaringClass().isInterface() || m.isDefault() || Modifier.isStatic(m.getModifiers())).collect(Collectors.toList());
    }

    private static Field[] applicableFieldsOf(Class<?> clazz) {
        Field[] declaredFields = clazz.getDeclaredFields();
        Arrays.sort(declaredFields, Comparator.comparing(Field::getName));
        return declaredFields;
    }

    private Stream<Class<?>> ancestry() {
        return JUnitQuickcheckTestClass.superclassHierarchy(this.getJavaClass()).flatMap(JUnitQuickcheckTestClass::interfaceAncestry);
    }

    private static Stream<Class<?>> superclassHierarchy(Class<?> clazz) {
        ArrayList hierarchy = new ArrayList();
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            hierarchy.add(c);
        }
        return hierarchy.stream();
    }

    private static Stream<Class<?>> interfaceAncestry(Class<?> clazz) {
        return Stream.concat(Stream.of(clazz), Arrays.stream(clazz.getInterfaces()).flatMap(JUnitQuickcheckTestClass::interfaceAncestry));
    }
}

