/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal.generator;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.internal.DefaultMethodHandleMaker;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class MarkerInterfaceGenerator<T>
extends Generator<T> {
    private final Class<T> markerType;

    public MarkerInterfaceGenerator(Class<T> markerType) {
        super(markerType);
        this.markerType = markerType;
    }

    @Override
    public T generate(SourceOfRandomness random, GenerationStatus status) {
        return this.markerType.cast(Proxy.newProxyInstance(this.markerType.getClassLoader(), new Class[]{this.markerType}, new MarkerInvocationHandler<T>(this.markerType)));
    }

    private static class MarkerInvocationHandler<T>
    implements InvocationHandler {
        private final Class<T> markerType;
        private final DefaultMethodHandleMaker methodHandleMaker = new DefaultMethodHandleMaker();

        public MarkerInvocationHandler(Class<T> markerType) {
            this.markerType = markerType;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (Object.class.equals(method.getDeclaringClass())) {
                return this.handleObjectMethod(proxy, method, args);
            }
            if (method.isDefault()) {
                return this.handleDefaultMethod(proxy, method, args);
            }
            return null;
        }

        private Object handleObjectMethod(Object proxy, Method method, Object[] args) {
            if ("equals".equals(method.getName())) {
                return proxy == args[0];
            }
            if ("hashCode".equals(method.getName())) {
                return System.identityHashCode(proxy);
            }
            return this.handleToString();
        }

        private Object handleDefaultMethod(Object proxy, Method method, Object[] args) throws Throwable {
            MethodHandle handle = this.methodHandleMaker.handleForSpecialMethod(method);
            return handle.bindTo(proxy).invokeWithArguments(args);
        }

        private String handleToString() {
            return "a synthetic instance of " + this.markerType;
        }
    }
}

