/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal.generator;

import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.internal.GeometricDistribution;
import com.pholser.junit.quickcheck.internal.ParameterSampler;
import com.pholser.junit.quickcheck.internal.PropertyParameterContext;
import com.pholser.junit.quickcheck.internal.constraint.ConstraintEvaluator;
import com.pholser.junit.quickcheck.internal.generator.AbstractGenerationStatus;
import com.pholser.junit.quickcheck.internal.generator.GeneratorRepository;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PropertyParameterGenerationContext
extends AbstractGenerationStatus {
    private final PropertyParameterContext parameter;
    private final ConstraintEvaluator evaluator;
    private final Generator<?> generator;
    private final int sampleSize;
    private int successfulEvaluations;
    private int discards;
    private int semiAttempts;

    public PropertyParameterGenerationContext(PropertyParameterContext parameter, GeneratorRepository repository, GeometricDistribution distro, SourceOfRandomness random, ParameterSampler sampler) {
        super(distro, PropertyParameterGenerationContext.initializeRandomness(parameter, random));
        this.parameter = parameter;
        this.evaluator = new ConstraintEvaluator(parameter.constraint());
        this.generator = sampler.decideGenerator(repository, parameter.typeContext());
        this.sampleSize = sampler.sizeFactor(parameter.typeContext());
    }

    private static SourceOfRandomness initializeRandomness(PropertyParameterContext p, SourceOfRandomness r) {
        if (p.fixedSeed()) {
            r.setSeed(p.seed());
        }
        return r;
    }

    public Object generate() {
        Object nextValue = this.generator.generate(this.random(), this);
        while (!this.evaluate(nextValue)) {
            nextValue = this.generator.generate(this.random(), this);
        }
        return nextValue;
    }

    public List<Object> shrink(Object larger) {
        return this.generator.canShrink(larger) ? new ArrayList(this.generator.shrink(this.random(), larger)) : Collections.emptyList();
    }

    private boolean evaluate(Object value) {
        this.evaluator.bind(value);
        boolean result = this.evaluator.evaluate();
        if (result) {
            ++this.successfulEvaluations;
        } else {
            ++this.discards;
        }
        if (this.tooManyDiscards()) {
            throw new DiscardRatioExceededException(this.parameter, this.discards, this.successfulEvaluations);
        }
        return result;
    }

    private boolean tooManyDiscards() {
        if (this.parameter.discardRatio() == 0) {
            return this.discards > this.sampleSize();
        }
        return this.successfulEvaluations == 0 ? this.discards > this.parameter.discardRatio() : this.discards / this.successfulEvaluations >= this.parameter.discardRatio();
    }

    @Override
    public int size() {
        return Math.min(super.size(), this.sampleSize());
    }

    @Override
    public int attempts() {
        return this.successfulEvaluations + this.discards + this.semiAttempts / 10;
    }

    @Override
    public void semiAttempt() {
        ++this.semiAttempts;
    }

    public long effectiveSeed() {
        return this.random().seed();
    }

    public int sampleSize() {
        return this.sampleSize;
    }

    public String name() {
        return this.parameter.typeContext().name();
    }

    public BigDecimal magnitude(Object value) {
        return this.generator.canShrink(value) ? this.generator.magnitude(value).abs() : BigDecimal.ZERO;
    }

    public static class DiscardRatioExceededException
    extends RuntimeException {
        static final String MESSAGE_TEMPLATE = "For parameter [%s] with discard ratio [%d], %d unsuccessful values and %d successes. Stopping.";
        private static final long serialVersionUID = Long.MIN_VALUE;

        DiscardRatioExceededException(PropertyParameterContext parameter, int discards, int successfulEvaluations) {
            super(String.format(MESSAGE_TEMPLATE, parameter.typeContext().name(), parameter.discardRatio(), discards, successfulEvaluations));
        }
    }
}

