/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.Generators;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;

public class Ctor<T>
extends Generator<T> {
    private final Constructor<T> ctor;
    private final Parameter[] parameters;
    private final List<Generator<?>> parameterGenerators = new ArrayList();

    public Ctor(Class<T> type) {
        this(Reflection.singleAccessibleConstructor(type));
    }

    public Ctor(Constructor<T> ctor) {
        super(ctor.getDeclaringClass());
        this.ctor = ctor;
        this.parameters = ctor.getParameters();
    }

    @Override
    public T generate(SourceOfRandomness random, GenerationStatus status) {
        return Reflection.instantiate(this.ctor, this.arguments(random, status));
    }

    @Override
    public void provide(Generators provided) {
        super.provide(provided);
        this.parameterGenerators.clear();
        for (Parameter each : this.parameters) {
            this.parameterGenerators.add(this.gen().parameter(each));
        }
    }

    @Override
    public void configure(AnnotatedType annotatedType) {
        super.configure(annotatedType);
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameterGenerators.get(i).configure(this.parameters[i].getAnnotatedType());
        }
    }

    @Override
    public Ctor<T> copy() {
        return new Ctor<T>(this.ctor);
    }

    private Object[] arguments(SourceOfRandomness random, GenerationStatus status) {
        Object[] args = new Object[this.parameters.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.parameterGenerators.get(i).generate(random, status);
        }
        return args;
    }
}

