/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;

final class FakeAnnotatedTypeFactory {
    private FakeAnnotatedTypeFactory() {
        throw new UnsupportedOperationException();
    }

    static AnnotatedType makeFrom(Class<?> clazz) {
        return clazz.isArray() ? FakeAnnotatedTypeFactory.makeArrayType(clazz) : FakeAnnotatedTypeFactory.makePlainType(clazz);
    }

    private static AnnotatedArrayType makeArrayType(Class<?> type) {
        return new FakeAnnotatedArrayType(type);
    }

    private static AnnotatedType makePlainType(Class<?> type) {
        return new FakeAnnotatedType(type);
    }

    private static final class FakeAnnotatedType
    implements AnnotatedType {
        private final Class<?> type;

        FakeAnnotatedType(Class<?> type) {
            this.type = type;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return null;
        }

        @Override
        public Annotation[] getAnnotations() {
            return new Annotation[0];
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return new Annotation[0];
        }
    }

    private static final class FakeAnnotatedArrayType
    implements AnnotatedArrayType {
        private final Class<?> type;

        FakeAnnotatedArrayType(Class<?> type) {
            this.type = type;
        }

        @Override
        public AnnotatedType getAnnotatedGenericComponentType() {
            return FakeAnnotatedTypeFactory.makeFrom(this.type.getComponentType());
        }

        @Override
        public AnnotatedType getAnnotatedOwnerType() {
            return null;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return null;
        }

        @Override
        public Annotation[] getAnnotations() {
            return new Annotation[0];
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return new Annotation[0];
        }
    }
}

