/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal.generator;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.Generators;
import com.pholser.junit.quickcheck.generator.NullAllowed;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.javaruntype.type.TypeParameter;

class NullableGenerator<T>
extends Generator<T> {
    private final Generator<T> delegate;
    private double probabilityOfNull = (Double)Reflection.defaultValueOf(NullAllowed.class, "probability");

    NullableGenerator(Generator<T> delegate) {
        super(delegate.types());
        this.delegate = delegate;
    }

    @Override
    public T generate(SourceOfRandomness random, GenerationStatus status) {
        return (double)random.nextFloat(0.0f, 1.0f) < this.probabilityOfNull ? null : (T)this.delegate.generate(random, status);
    }

    @Override
    public boolean canRegisterAsType(Class<?> type) {
        return this.delegate.canRegisterAsType(type);
    }

    @Override
    public boolean hasComponents() {
        return this.delegate.hasComponents();
    }

    @Override
    public int numberOfNeededComponents() {
        return this.delegate.numberOfNeededComponents();
    }

    @Override
    public void addComponentGenerators(List<Generator<?>> newComponents) {
        this.delegate.addComponentGenerators(newComponents);
    }

    @Override
    public boolean canGenerateForParametersOfTypes(List<TypeParameter<?>> typeParameters) {
        return this.delegate.canGenerateForParametersOfTypes(typeParameters);
    }

    @Override
    public void configure(AnnotatedType annotatedType) {
        Optional.ofNullable(annotatedType.getAnnotation(NullAllowed.class)).ifPresent(this::configure);
        this.delegate.configure(annotatedType);
    }

    @Override
    public void configure(AnnotatedElement element) {
        this.delegate.configure(element);
    }

    @Override
    public void provide(Generators provided) {
        this.delegate.provide(provided);
    }

    @Override
    public boolean canShrink(Object larger) {
        return this.delegate.canShrink(larger);
    }

    @Override
    public List<T> doShrink(SourceOfRandomness random, T larger) {
        return this.delegate.doShrink(random, larger);
    }

    @Override
    public BigDecimal magnitude(Object value) {
        return this.delegate.magnitude(value);
    }

    private void configure(NullAllowed allowed) {
        if (!(allowed.probability() >= 0.0) || !(allowed.probability() <= 1.0)) {
            throw new IllegalArgumentException("NullAllowed probability must be in the range [0, 1]");
        }
        this.probabilityOfNull = allowed.probability();
    }
}

