/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.lang;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.util.Arrays;

public class CharacterGenerator
extends Generator<Character> {
    private char min = ((Character)Reflection.defaultValueOf(InRange.class, (String)"minChar")).charValue();
    private char max = ((Character)Reflection.defaultValueOf(InRange.class, (String)"maxChar")).charValue();

    public CharacterGenerator() {
        super(Arrays.asList(Character.TYPE, Character.class));
    }

    public void configure(InRange range) {
        this.min = range.min().isEmpty() ? range.minChar() : range.min().charAt(0);
        this.max = range.max().isEmpty() ? range.maxChar() : range.max().charAt(0);
    }

    public Character generate(SourceOfRandomness random, GenerationStatus status) {
        return Character.valueOf(random.nextChar(this.min, this.max));
    }
}

