/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.lang;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.util.Arrays;

public class DoubleGenerator
extends Generator<Double> {
    private double min = (Double)Reflection.defaultValueOf(InRange.class, (String)"minDouble");
    private double max = (Double)Reflection.defaultValueOf(InRange.class, (String)"maxDouble");

    public DoubleGenerator() {
        super(Arrays.asList(Double.TYPE, Double.class));
    }

    public void configure(InRange range) {
        this.min = range.min().isEmpty() ? range.minDouble() : Double.parseDouble(range.min());
        this.max = range.max().isEmpty() ? range.maxDouble() : Double.parseDouble(range.max());
    }

    public Double generate(SourceOfRandomness random, GenerationStatus status) {
        return random.nextDouble(this.min, this.max);
    }
}

