/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.lang;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.GeneratorConfiguration;
import com.pholser.junit.quickcheck.generator.java.lang.strings.CodePoints;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.charset.Charset;

public class Encoded
extends Generator<String> {
    private Charset charset = Charset.defaultCharset();

    public Encoded() {
        super(String.class);
    }

    public void configure(InCharset c) {
        this.charset = Charset.forName(c.value());
    }

    public String generate(SourceOfRandomness random, GenerationStatus status) {
        CodePoints charsetPoints = CodePoints.forCharset(this.charset);
        int[] codePoints = new int[status.size()];
        for (int i = 0; i < codePoints.length; ++i) {
            codePoints[i] = charsetPoints.at(random.nextInt(0, charsetPoints.size() - 1));
        }
        return new String(codePoints, 0, codePoints.length);
    }

    @Target(value={ElementType.PARAMETER, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @GeneratorConfiguration
    public static @interface InCharset {
        public String value();
    }
}

