/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.lang;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.util.Arrays;

public class FloatGenerator
extends Generator<Float> {
    private float min = ((Float)Reflection.defaultValueOf(InRange.class, (String)"minFloat")).floatValue();
    private float max = ((Float)Reflection.defaultValueOf(InRange.class, (String)"maxFloat")).floatValue();

    public FloatGenerator() {
        super(Arrays.asList(Float.TYPE, Float.class));
    }

    public void configure(InRange range) {
        this.min = range.min().isEmpty() ? range.minFloat() : Float.parseFloat(range.min());
        this.max = range.max().isEmpty() ? range.maxFloat() : Float.parseFloat(range.max());
    }

    public Float generate(SourceOfRandomness random, GenerationStatus status) {
        return Float.valueOf(random.nextFloat(this.min, this.max));
    }
}

