/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.lang;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.util.Arrays;

public class IntegerGenerator
extends Generator<Integer> {
    private int min = (Integer)Reflection.defaultValueOf(InRange.class, (String)"minInt");
    private int max = (Integer)Reflection.defaultValueOf(InRange.class, (String)"maxInt");

    public IntegerGenerator() {
        super(Arrays.asList(Integer.TYPE, Integer.class));
    }

    public void configure(InRange range) {
        this.min = range.min().isEmpty() ? range.minInt() : Integer.parseInt(range.min());
        this.max = range.max().isEmpty() ? range.maxInt() : Integer.parseInt(range.max());
    }

    public Integer generate(SourceOfRandomness random, GenerationStatus status) {
        return random.nextInt(this.min, this.max);
    }
}

