/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.util;

import com.pholser.junit.quickcheck.generator.ComponentizedGenerator;
import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.Size;
import com.pholser.junit.quickcheck.internal.Ranges;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.util.Collection;

public abstract class CollectionGenerator<T extends Collection>
extends ComponentizedGenerator<T> {
    private Size sizeRange;

    protected CollectionGenerator(Class<T> type) {
        super(type);
    }

    public void configure(Size sizeRange) {
        this.sizeRange = sizeRange;
        Ranges.checkRange((Ranges.Type)Ranges.Type.INTEGRAL, (Comparable)Integer.valueOf(sizeRange.min()), (Comparable)Integer.valueOf(sizeRange.max()));
    }

    public T generate(SourceOfRandomness random, GenerationStatus status) {
        int size = this.size(random, status);
        T items = this.empty();
        for (int i = 0; i < size; ++i) {
            items.add((Object)((Generator)this.componentGenerators().get(0)).generate(random, status));
        }
        return items;
    }

    public int numberOfNeededComponents() {
        return 1;
    }

    public boolean canRegisterAsType(Class<?> type) {
        return !Object.class.equals(type);
    }

    protected abstract T empty();

    private int size(SourceOfRandomness random, GenerationStatus status) {
        return this.sizeRange != null ? random.nextInt(this.sizeRange.min(), this.sizeRange.max()) : status.size();
    }
}

