/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.time;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.time.Duration;

public class DurationGenerator
extends Generator<Duration> {
    private Duration min = Duration.ofSeconds(Long.MIN_VALUE, 0L);
    private Duration max = Duration.ofSeconds(Long.MAX_VALUE, 999999999L);

    public DurationGenerator() {
        super(Duration.class);
    }

    public void configure(InRange range) {
        if (!Reflection.defaultValueOf(InRange.class, (String)"min").equals(range.min())) {
            this.min = Duration.parse(range.min());
        }
        if (!Reflection.defaultValueOf(InRange.class, (String)"max").equals(range.max())) {
            this.max = Duration.parse(range.max());
        }
        if (this.min.compareTo(this.max) > 0) {
            throw new IllegalArgumentException(String.format("bad range, %s > %s", range.min(), range.max()));
        }
    }

    public Duration generate(SourceOfRandomness random, GenerationStatus status) {
        return random.nextDuration(this.min, this.max);
    }
}

