/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator;

import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.internal.Sequences;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class DecimalGenerator<T extends Number>
extends Generator<T> {
    protected DecimalGenerator(Class<T> type) {
        super(Collections.singletonList(type));
    }

    protected DecimalGenerator(List<Class<T>> types) {
        super(types);
    }

    public List<T> doShrink(SourceOfRandomness random, T largestGeneric) {
        if (largestGeneric.equals(this.leastMagnitude())) {
            return Collections.emptyList();
        }
        BigDecimal largest = this.widen().apply(largestGeneric);
        BigDecimal least = this.widen().apply(this.leastMagnitude());
        ArrayList<T> results = new ArrayList<T>();
        if (this.negative(largestGeneric)) {
            results.add(this.negate(largestGeneric));
        }
        results.add(this.leastMagnitude());
        results.addAll(this.shrunkenIntegrals(largest, least));
        results.addAll(this.shrunkenDecimals(largest, least));
        return results;
    }

    private List<T> shrunkenIntegrals(BigDecimal largest, BigDecimal least) {
        return this.decimalsFrom(StreamSupport.stream(Sequences.halvingIntegral((BigInteger)largest.toBigInteger(), (BigInteger)least.toBigInteger()).spliterator(), false).map(BigDecimal::new));
    }

    private List<T> shrunkenDecimals(BigDecimal largest, BigDecimal least) {
        return this.decimalsFrom(StreamSupport.stream(Sequences.halvingDecimal((BigDecimal)largest, (BigDecimal)least).spliterator(), false));
    }

    private List<T> decimalsFrom(Stream<BigDecimal> stream) {
        return stream.limit(15L).map(this.narrow()).filter(this.inRange()).distinct().collect(Collectors.toList());
    }

    protected abstract Function<T, BigDecimal> widen();

    protected abstract Function<BigDecimal, T> narrow();

    protected abstract Predicate<T> inRange();

    protected abstract T leastMagnitude();

    protected abstract boolean negative(T var1);

    protected abstract T negate(T var1);
}

