/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator;

import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.internal.Sequences;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public abstract class IntegralGenerator<T extends Number>
extends Generator<T> {
    protected IntegralGenerator(Class<T> type) {
        super(Collections.singletonList(type));
    }

    protected IntegralGenerator(List<Class<T>> types) {
        super(types);
    }

    public List<T> doShrink(SourceOfRandomness random, T larger) {
        if (larger.equals(this.leastMagnitude())) {
            return Collections.emptyList();
        }
        ArrayList<T> results = new ArrayList<T>();
        if (this.negative(larger)) {
            results.add(this.negate(larger));
        }
        results.add(this.leastMagnitude());
        results.addAll(StreamSupport.stream(Sequences.halvingIntegral((BigInteger)this.widen().apply(larger), (BigInteger)this.widen().apply(this.leastMagnitude())).spliterator(), false).limit(15L).map(this.narrow()).filter(this.inRange()).distinct().collect(Collectors.toList()));
        return results;
    }

    protected Function<T, BigInteger> widen() {
        return n -> BigInteger.valueOf(n.longValue());
    }

    protected abstract Function<BigInteger, T> narrow();

    protected abstract Predicate<T> inRange();

    protected abstract T leastMagnitude();

    protected abstract boolean negative(T var1);

    protected abstract T negate(T var1);
}

