/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.lang;

import com.pholser.junit.quickcheck.generator.GeneratorConfiguration;
import com.pholser.junit.quickcheck.generator.java.lang.AbstractStringGenerator;
import com.pholser.junit.quickcheck.generator.java.lang.strings.CodePoints;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.charset.Charset;

public class Encoded
extends AbstractStringGenerator {
    private CodePoints charsetPoints;

    public Encoded() {
        this.initialize(Charset.defaultCharset());
    }

    public void configure(InCharset charset) {
        this.initialize(Charset.forName(charset.value()));
    }

    private void initialize(Charset charset) {
        this.charsetPoints = CodePoints.forCharset(charset);
    }

    @Override
    protected int nextCodePoint(SourceOfRandomness random) {
        return this.charsetPoints.at(random.nextInt(0, this.charsetPoints.size() - 1));
    }

    @Override
    protected boolean codePointInRange(int codePoint) {
        return this.charsetPoints.contains(codePoint);
    }

    @Target(value={ElementType.PARAMETER, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @GeneratorConfiguration
    public static @interface InCharset {
        public String value();
    }
}

