/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.util;

import com.pholser.junit.quickcheck.generator.ComponentizedGenerator;
import com.pholser.junit.quickcheck.generator.Distinct;
import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.Shrink;
import com.pholser.junit.quickcheck.generator.Size;
import com.pholser.junit.quickcheck.internal.Lists;
import com.pholser.junit.quickcheck.internal.Ranges;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.internal.Sequences;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class MapGenerator<T extends Map>
extends ComponentizedGenerator<T> {
    private Size sizeRange;
    private boolean distinct;

    protected MapGenerator(Class<T> type) {
        super(type);
    }

    public void addComponentGenerators(List<Generator<?>> newComponents) {
        super.addComponentGenerators(newComponents);
    }

    public void configure(Size size) {
        this.sizeRange = size;
        Ranges.checkRange((Ranges.Type)Ranges.Type.INTEGRAL, (Comparable)Integer.valueOf(size.min()), (Comparable)Integer.valueOf(size.max()));
    }

    public void configure(Distinct distinct) {
        this.distinct = distinct != null;
    }

    public T generate(SourceOfRandomness random, GenerationStatus status) {
        int size = this.size(random, status);
        Generator keyGenerator = (Generator)this.componentGenerators().get(0);
        Stream<Object> keyStream = (Stream<Object>)Stream.generate(() -> keyGenerator.generate(random, status)).sequential();
        if (this.distinct) {
            keyStream = keyStream.distinct();
        }
        Object items = this.empty();
        Generator valueGenerator = (Generator)this.componentGenerators().get(1);
        keyStream.map(key -> new AbstractMap.SimpleEntry<Object, Object>(key, valueGenerator.generate(random, status))).filter(entry -> this.okToAdd(entry.getKey(), entry.getValue())).limit(size).forEach(entry -> items.put(entry.getKey(), entry.getValue()));
        return items;
    }

    public List<T> doShrink(SourceOfRandomness random, T larger) {
        ArrayList entries = new ArrayList(larger.entrySet());
        ArrayList<T> shrinks = new ArrayList<T>(this.removals(entries));
        Shrink<Map.Entry<?, ?>> entryShrink = this.entryShrinker((Shrink<Object>)((Shrink)this.componentGenerators().get(0)), (Shrink<Object>)((Shrink)this.componentGenerators().get(1)));
        Stream<Object> oneEntryShrinks = Lists.shrinksOfOneItem((SourceOfRandomness)random, entries, entryShrink).stream();
        if (this.distinct) {
            oneEntryShrinks = oneEntryShrinks.filter(MapGenerator::isKeyDistinct);
        }
        shrinks.addAll(oneEntryShrinks.map(this::convert).filter(this::inSizeRange).collect(Collectors.toList()));
        return shrinks;
    }

    public int numberOfNeededComponents() {
        return 2;
    }

    public BigDecimal magnitude(Object value) {
        Map narrowed = (Map)this.narrow(value);
        if (narrowed.isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal keysMagnitude = narrowed.keySet().stream().map(e -> ((Generator)this.componentGenerators().get(0)).magnitude(e)).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal valuesMagnitude = narrowed.values().stream().map(e -> ((Generator)this.componentGenerators().get(1)).magnitude(e)).reduce(BigDecimal.ZERO, BigDecimal::add);
        return BigDecimal.valueOf(narrowed.size()).multiply(keysMagnitude).add(valuesMagnitude);
    }

    protected final T empty() {
        return (T)((Map)Reflection.instantiate((Constructor)Reflection.findConstructor((Class)((Class)this.types().get(0)), (Class[])new Class[0]), (Object[])new Object[0]));
    }

    protected boolean okToAdd(Object key, Object value) {
        return true;
    }

    private boolean inSizeRange(T target) {
        return this.sizeRange == null || target.size() >= this.sizeRange.min() && target.size() <= this.sizeRange.max();
    }

    private int size(SourceOfRandomness random, GenerationStatus status) {
        return this.sizeRange != null ? random.nextInt(this.sizeRange.min(), this.sizeRange.max()) : status.size();
    }

    private List<T> removals(List<Map.Entry<?, ?>> items) {
        return StreamSupport.stream(Sequences.halving((int)items.size()).spliterator(), false).map(i -> Lists.removeFrom((List)items, (int)i)).flatMap(Collection::stream).map(this::convert).filter(this::inSizeRange).collect(Collectors.toList());
    }

    private T convert(List<?> entries) {
        T converted = this.empty();
        for (Object each : entries) {
            Map.Entry entry = (Map.Entry)each;
            converted.put(entry.getKey(), entry.getValue());
        }
        return converted;
    }

    private Shrink<Map.Entry<?, ?>> entryShrinker(Shrink<Object> keyShrinker, Shrink<Object> valueShrinker) {
        return (r, e) -> {
            Map.Entry entry = (Map.Entry)e;
            List keyShrinks = keyShrinker.shrink(r, entry.getKey());
            List valueShrinks = valueShrinker.shrink(r, entry.getValue());
            ArrayList shrinks = new ArrayList();
            shrinks.addAll(keyShrinks.stream().map(k -> new AbstractMap.SimpleEntry(k, entry.getValue())).collect(Collectors.toList()));
            shrinks.addAll(valueShrinks.stream().map(v -> new AbstractMap.SimpleEntry(entry.getKey(), v)).collect(Collectors.toList()));
            return shrinks;
        };
    }

    private static boolean isKeyDistinct(List<Map.Entry<?, ?>> entries) {
        return Lists.isDistinct(entries.stream().map(Map.Entry::getKey).collect(Collectors.toList()));
    }
}

