/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.util;

import com.pholser.junit.quickcheck.generator.ComponentizedGenerator;
import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class OptionalGenerator
extends ComponentizedGenerator<Optional> {
    public OptionalGenerator() {
        super(Optional.class);
    }

    public Optional<?> generate(SourceOfRandomness random, GenerationStatus status) {
        double trial = random.nextDouble();
        return trial < 0.25 ? Optional.empty() : Optional.of(((Generator)this.componentGenerators().get(0)).generate(random, status));
    }

    public List<Optional> doShrink(SourceOfRandomness random, Optional larger) {
        if (!larger.isPresent()) {
            return new ArrayList<Optional>();
        }
        ArrayList<Optional> shrinks = new ArrayList<Optional>();
        shrinks.add(Optional.empty());
        shrinks.addAll(((Generator)this.componentGenerators().get(0)).shrink(random, larger.get()).stream().map(Optional::of).collect(Collectors.toList()));
        return shrinks;
    }

    public int numberOfNeededComponents() {
        return 1;
    }

    public BigDecimal magnitude(Object value) {
        Optional narrowed = (Optional)this.narrow(value);
        return narrowed.map(arg_0 -> ((Generator)((Generator)this.componentGenerators().get(0))).magnitude(arg_0)).orElse(BigDecimal.ZERO);
    }
}

